% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nearest_payoff.R
\name{nearest_payoff}
\alias{nearest_payoff}
\title{Find Nearest Payoff}
\usage{
nearest_payoff(vl_diff, payoffs_list)
}
\arguments{
\item{vl_diff}{Numeric value representing the viral load difference for which the
nearest payoff will be found.}

\item{payoffs_list}{A named list of payoff values, where the names correspond to
specific payoffs and the values are the associated payoff values.}
}
\description{
This function computes the nearest simulated payoff from a given list of payoffs
based on a viral load difference (vl_diff). It returns both the nearest payoff value
and its corresponding payoff name.
}
\examples{
 I <- diag(2)
 H <- 1 / sqrt(2) * matrix(c(1, 1, 1, -1), 2, 2)
 Z <- diag(c(1, -1))
 gates <- list(I = I, H = H, Z = Z)
 alpha <- 0.3; beta <- 0.1; gamma <- 0.5; theta <- 0.2
 alpha2 <- 0.35; beta2 <- 0.15; gamma2 <- 0.6; theta2 <- 0.25
 pays <- payoffs_list(gates, alpha, beta, gamma, theta, alpha2, beta2, gamma2, theta2)
 nearest_payoff(-0.2, pays)
}
