% Generated by roxygen2 (4.0.2): do not edit by hand
\name{multi.split}
\alias{multi.split}
\title{Split a multiple choices variable in a series of binary variables}
\usage{
multi.split(var, split.char = "/", mnames = NULL)
}
\arguments{
\item{var}{variable to split}

\item{split.char}{character to split at}

\item{mnames}{names to give to the produced variabels. If NULL, the name are computed from the original variable name and the answers.}
}
\value{
Returns a data frame.
}
\description{
Split a multiple choices variable in a series of binary variables
}
\details{
This function takes as input a multiple choices variable where choices
are recorded as a string and separated with a fixed character. For example,
if the question is about the favourite colors, answers could be "red/blue",
"red/green/yellow", etc. This function splits the variable into as many variables
as the number of different choices. Each of these variables as a 1 or 0 value
corresponding to the choice of this answer. They are returned as a data frame.
##'
}
\examples{
v <- c("red/blue","green","red/green","blue/red")
multi.split(v)
## One-way frequency table of the result
multi.table(multi.split(v))
}
\seealso{
\code{\link[questionr]{multi.table}}
}

