\name{lookfor}
\alias{lookfor}
\title{Look for keywords variable names and descriptions}
\source{
  Based on the behaviour of the \code{lookfor} command in
  Stata. Future versions might include fuzzey search as
  featured by the \code{query} function of the
  \code{memisc} package, which also searches value labels
  and therefore offers a wider search scope.
}
\usage{
  lookfor(data, keywords = "weight|sample", labels = TRUE,
    ignore.case = TRUE)
}
\arguments{
  \item{data}{a data frame that can be annotated by the
  \code{foreign} or \code{memisc} packages.}

  \item{keywords}{a character string, which can be
  formatted as a regular expression suitable for a
  \code{grep} pattern, or a vector of keywords; searches
  for keywords 'sample' and 'weight' by default}

  \item{labels}{whether or not to search variable labels
  (descriptions); \code{TRUE} by default}

  \item{ignore.case}{whether or not to make the keywords
  case sensitive; \code{TRUE} by default (case is ignored
  during matching)}
}
\value{
  a data frame featuring the variable position, name and
  description (if it exists) in the original data frame
}
\description{
  \code{lookfor} emulates the \code{lookfor} Stata command
  in R. It supports searching into the variable names of
  regular R data frames as well as into SPSS and Stata
  datasets loaded in R via the \code{foreign} or
  \code{memisc} packages, in which case it will also search
  variable descriptions (labels). The command is meant to
  help users finding variables in large datasets.
}
\details{
  The function looks into the variable names for matches to
  the keywords. If the data frame has been read into R with
  a method that provides variable labels (\code{read.dta}
  or \code{read.spss} in the \code{foreign} package, or any
  of the importer methods of the \code{memisc} package),
  then variable labels are included in the search scope.
}
\examples{
# Look for a single keyword.
lookfor(iris, "petal")
# Load memisc package and example data.
require(memisc)
nes1948.por <- UnZip("anes/NES1948.ZIP","NES1948.POR", package="memisc")
nes1948 <- spss.portable.file(nes1948.por)
# Look for a vector of keywords.
lookfor(nes1948, c("Truman", "Dewey"))
# Look for a regular expression.
lookfor(nes1948, "truman|dewey")
# Look for a phrase.
lookfor(nes1948, "personal attribute")
}
\author{
  François Briatte <f.briatte@ed.ac.uk>
}
\seealso{
  \code{\link{query}} in the \link{memisc} package
}

