% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/models.R
\name{ts-models-AR2}
\alias{AR2}
\alias{ts-models-AR2}
\title{Simulation of an AR(2) time series.}
\usage{
AR2(n, a1, a2, overhead = 500, innov = rnorm)
}
\arguments{
\item{n}{length of the time series to be returned}

\item{a1}{parameter}

\item{a2}{parameter}

\item{overhead}{an integer specifying the ``warmup'' period to reach an
approximate stationary start for the times series}

\item{innov}{a function with one parameter \code{n} that yields \code{n}
independent pseudo random numbers each time it is called.}
}
\value{
Return an AR(2) time series with specified parameters.
}
\description{
Returns a simulated time series \eqn{(Y_t)} that fulfills the following equation:
\deqn{Y_t = a_1 Y_{t-1} + a_2 Y_{t-2} + \epsilon_t,}
where \eqn{a_1} and \eqn{a_2} are parameters and \eqn{\epsilon_t} is
independent white noise with marginal distribution specified by the
parameter \code{innov}.
}
\examples{
plot(AR2(100, a1=0, a2=0.5), type="l")
}

