\name{QRegEstimator-constructor}
\alias{QRegEstimator-constructor}
\alias{qRegEstimator}
\title{Create an instance of the \code{QRegEstimator} class.}
\usage{
qRegEstimator(Y, frequencies = 2 * pi/length(Y) * 0:(length(Y) - 1),
  levels = 0.5, isRankBased = TRUE, B = 0, l = 0,
  type.boot = c("none", "mbb"), method = c("br", "fn", "pfn", "fnc",
  "lasso", "scad"), parallel = FALSE)
}
\arguments{
  \item{Y}{A \code{vector} of real numbers containing the
  time series from which to determine the quantile
  periodogram or a \code{ts} object or a \code{zoo}
  object.}

  \item{isRankBased}{If true the time series is first
  transformed to pseudo data [cf. \code{\link{FreqRep}}].}

  \item{levels}{A vector of length \code{K} containing the
  levels \code{x} at which the \code{QRegEstimator} is to
  be determined.}

  \item{frequencies}{A vector containing frequencies at
  which to determine the \code{QRegEstimator}.}

  \item{B}{number of bootstrap replications}

  \item{l}{(expected) length of blocks}

  \item{type.boot}{A flag to choose a method for the block
  bootstrap; currently two options are implemented:
  \code{"none"} and \code{"mbb"} which means to do a moving
  blocks bootstrap with \code{B} and \code{l} as
  specified.}

  \item{method}{method used for computing the quantile
  regression estimates.  The choice is passed to \code{qr};
  see the documentation of \code{quantreg} for details.}

  \item{parallel}{a flag to allow performing parallel
  computations.}
}
\value{
Returns an instance of \code{QRegEstimator}.
}
\description{
The parameter \code{type.boot} can be set to choose a block
bootstrapping procedure. If \code{"none"} is chosen, a
moving blocks bootstrap with \code{l=length(Y)} and
\code{N=length(Y)} would be done. Note that in that case
one would also chose \code{B=0} which means that
\code{getPositions} would never be called. If \code{B>0}
then each bootstrap replication would be the undisturbed
time series.
}
\examples{
library(snowfall)

Y <- rnorm(100) # Try 2000 and parallel computation will in fact be faster.

# Compute without using snowfall capabilities
system.time(
  qRegEst1 <- qRegEstimator(Y, levels=seq(0.25,0.75,0.25), parallel=FALSE)
)

# Set up snowfall
sfInit(parallel=TRUE, cpus=2, type="SOCK")
sfLibrary(quantreg)
sfExportAll()

# Compare how much faster the computation is when done in parallel
system.time(
  qRegEst2 <- qRegEstimator(Y, levels=seq(0.25,0.75,0.25), parallel=TRUE)
)

sfStop()

# Compare results
V1 <- getValues(qRegEst1)
V2 <- getValues(qRegEst2)
sum(abs(V1-V2)) # Returns: [1] 0
}
\keyword{Constructors}

