% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/crossqreg.sb.R
\name{crossqreg.sb}
\alias{crossqreg.sb}
\title{Stationary Bootstrap for the Cross-Quantilogram}
\usage{
crossqreg.sb(DATA1, DATA2, vecA, k, gamma, Bsize, sigLev)
}
\arguments{
\item{DATA1}{The original data matrix (T x p1)}

\item{DATA2}{The original data matrix (T x p2)}

\item{vecA}{A pair of two probability values at which sample quantiles are estimated}

\item{k}{A lag order}

\item{gamma}{A parameter for the stationary bootstrap}

\item{Bsize}{The number of repetition of bootstrap}

\item{sigLev}{The statistical significance level}
}
\value{
The boostrap critical values
}
\description{
Returns critical values for the cross-quantilogram, based on the stationary bootstrap.
}
\details{
This function generates critical values for for the cross-quantilogram,
using the stationary bootstrap in Politis and Romano (1994).
}
\examples{
data(sys.risk) 

## sample size
T = nrow(sys.risk)

## matrix for quantile regressions
## - 1st column: dependent variables
## - the rest:   regressors or predictors 
D1 = cbind(sys.risk[2:T,"Market"], sys.risk[1:(T-1),"Market"])
D2 = cbind(sys.risk[2:T,"JPM"], sys.risk[1:(T-1),"JPM"])

## probability levels
vecA = c(0.1, 0.2)

## setup for stationary bootstrap
gamma  = 1/10 ## bootstrap parameter depending on data
Bsize  = 5    ## small size 10 for test 
sigLev = 0.05 ## significance level

## cross-quantilogram with the lag of 5, after quantile regression 
crossqreg.sb(D1, D2, vecA, 5, gamma, Bsize, sigLev)

}
\references{
Han, H., Linton, O., Oka, T., and Whang, Y. J. (2016).
"The cross-quantilogram: Measuring quantile dependence and testing directional predictability between time series." \emph{Journal of Econometrics}, 193(1), 251-270.

Politis, Dimitris N., and Joseph P. Romano.
"The stationary bootstrap."
\emph{Journal of the American Statistical Association} 89.428 (1994): 1303-1313.
}
\author{
Heejoon Han, Oliver Linton, Tatsushi Oka and Yoon-Jae Whang
}
