% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dictionaries-deprecated.R
\name{applyDictionary}
\alias{applyDictionary}
\alias{applyDictionary.tokens}
\alias{applyDictionary.tokenizedTexts}
\alias{applyDictionary.dfm}
\title{apply a dictionary or thesaurus to an object}
\usage{
applyDictionary(x, dictionary, ...)

\method{applyDictionary}{tokens}(x, ...)

\method{applyDictionary}{tokenizedTexts}(x, ...)

\method{applyDictionary}{dfm}(x, ...)
}
\arguments{
\item{x}{object to which dictionary or thesaurus will be supplied}

\item{dictionary}{the \link{dictionary}-class object that will be applied to
\code{x}}

\item{...}{not used}

\item{exclusive}{if \code{TRUE}, remove all features not in dictionary, 
otherwise, replace values in dictionary with keys while leaving other 
features unaffected}

\item{case_insensitive}{ignore the case of dictionary values if \code{TRUE}}

\item{capkeys}{if \code{TRUE}, convert dictionary keys to
uppercase to distinguish them from other features}

\item{verbose}{print status messages if \code{TRUE}}
}
\value{
an object of the type passed with the value-matching features
  replaced by dictionary keys
}
\description{
Convert features into equivalence classes defined by values of a dictionary 
object.
}
\details{
\code{applyDictionary.dfm} is the deprecated function name for
\code{\link{dfm_lookup}}.
}
\note{
Selecting only features defined in a "dictionary" is traditionally 
  known in text analysis as a \emph{dictionary method}, even though
  technically this "dictionary" operates more like a thesarus.  If a thesaurus-like
  application is desired, set \code{exclusive = FALSE} to convert features 
  defined as values in a dictionary into their keys, while keeping all other
  features.
}
\examples{
\donttest{
toks <- tokens(data_corpus_inaugural)
head(kwic(toks, "united states"))
dict <- dictionary(list(country = "united states"))
toks2 <- applyDictionary(toks, dict, valuetype = "fixed")
toks2
}
}
\keyword{deprecated}
\keyword{internal}
