% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/dataDocs.R, R/syllables.R
\docType{data}
\name{syllables}
\alias{englishSyllables}
\alias{syllables}
\alias{syllables.character}
\alias{syllables.tokenizedTexts}
\title{count syllables in a text}
\source{
\code{englishSyllables} is built from the freely available CMU pronunciation dictionary at \code{http://www.speech.cs.cmu.edu/cgi-bin/cmudict}.
}
\usage{
syllables(x, ...)

\method{syllables}{character}(x, syllableDict = quanteda::englishSyllables,
  ...)

\method{syllables}{tokenizedTexts}(x,
  syllableDict = quanteda::englishSyllables, ...)
}
\arguments{
\item{x}{character vector or \code{tokenizedText-class} object  whose
syllables will be counted}

\item{...}{additional arguments passed to tokenize}

\item{syllableDict}{optional named integer vector of syllable counts where
the names are lower case tokens.  When set to \code{NULL} (default), then
the function will use the quanteda data object \code{englishSyllables}, an
English pronunciation dictionary from CMU.}
}
\value{
If \code{x} is a character vector, a named numeric vector of the
  counts of the syllables in each text, without tokenization.  If \code{x}
  consists of (a list of) tokenized texts, then return a list of syllable
  counts corresponding to the tokenized texts.
}
\description{
Returns a count of the number of syllables in texts. For English
  words, the syllable count is exact and looked up from the CMU pronunciation
  dictionary, from the default syllable dictionary \code{englishSyllables}.
  For any word not in the dictionary, the syllable count is estimated by
  counting vowel clusters.

  \code{englishSyllables} is a quanteda-supplied data object consisting of a
  named numeric vector of syllable counts for the words used as names.  This
  is the default object used to count English syllables.  This object that
  can be accessed directly, but we strongly encourage you to access it only
  through the \code{syllables()} wrapper function.
}
\note{
All tokens are automatically converted to lowercase to perform the
  matching with the syllable dictionary, so there is no need to perform this
  step prior to calling \code{syllables()}.
}
\examples{
syllables("This is an example sentence.")
syllables(tokenize("This is an example sentence.", simplify=TRUE))
myTexts <- c(text1 = "Text one.",
             text2 = "Superduper text number two.",
             text3 = "One more for the road.")
syllables(myTexts)
syllables(tokenize(myTexts, removePunct = TRUE))
syllables("supercalifragilisticexpialidocious")
}

