% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/volcano2G.R
\name{volcano2GB}
\alias{volcano2GB}
\title{Volcano with more control}
\usage{
volcano2GB(dataX, foldchange = "log2FC", pvalue = "q.mod",
  labels = "names", pthresh = 0.1, log2FCThresh = 0.5, main = NULL,
  xlab = "log2 FC", ylab = "-log10(Q Value)", repel.text.size = 1,
  repel.segment.size = 0.5, repel.segement.alpha = 0.5, pseudo = NULL)
}
\arguments{
\item{dataX}{dataX frame}

\item{foldchange}{column name with fold change plotted on X}

\item{pvalue}{column with pvalue or qvalue plotted as -log10 on y axes}

\item{labels}{column containing lables}

\item{pthresh}{horizontal abline}

\item{log2FCThresh}{vertical abline}

\item{main}{main plot title}

\item{xlab}{xlab}

\item{ylab}{ylab}

\item{repel.text.size}{ggrepel parameter}

\item{repel.segment.size}{ggrepel parameter}

\item{repel.segement.alpha}{ggrepel parameter}

\item{pseudo}{add pseudo fold changes}
}
\description{
Volcano with more control
}
\examples{
rm(list=ls())

library(ggrepel)
library(quantable)
foldchange <- rnorm(1000)
pvals <-rexp(1000)
names <- sample(colors(),1000,replace=TRUE)

dataX <- data.frame(q.mod = pvals,
 log2FC = foldchange,
  names = names )
  
volcano2GB(dataX)
b <- volcano2GB(dataX, pthresh=0.1, log2FCThresh=0.5 ,
 main='test', repel.segment.size=0.3,repel.text.size=2)
b
}
