% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/volcano2G.R
\name{volcano2G}
\alias{volcano2G}
\title{DEPRECATED Volcano plot using ggplot and ggrepel}
\usage{
volcano2G(foldchange, pvals, labels, pthresh = 0.1, log2FCThresh = 0.5,
  main = NULL, xlab = "log2 FC", ylab = "-log10(Q Value)", xlim = c(-5,
  5), ylim = c(0, -log10(min(pvals, na.rm = TRUE))), size = 1,
  segment.size = 0.3, segement.alpha = 0.3, pseudo = NULL,
  colors = NULL)
}
\arguments{
\item{foldchange}{vector with fold changes}

\item{pvals}{vector with pvalues}

\item{labels}{vector with labels}

\item{pthresh}{pvalue threshold}

\item{log2FCThresh}{log2 FC threshold}

\item{main}{main title}

\item{xlab}{xlab}

\item{ylab}{ylab}

\item{xlim}{xlim}

\item{ylim}{ylim}

\item{size}{see geom_text_repel}

\item{segment.size}{see geom_text_repel}

\item{segement.alpha}{see geom_text_repel}

\item{pseudo}{usually q.mod containing NAs}

\item{colors}{specify colors for specific lables.}
}
\description{
DEPRECATED Volcano plot using ggplot and ggrepel
}
\examples{
rm(list=ls())
library(quantable)
foldchange <- rnorm(1000)
pvals <-rexp(1000)
volcano2G(foldchange, pvals,labels=rep("abcde", length(pvals)),
  pthresh=0.1, log2FCThresh=0.5,main='test',size=2,segment.size=0.3)

}
