% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/classes.R
\docType{class}
\name{Quadtree-class}
\alias{Quadtree-class}
\alias{Quadtree}
\title{Quadtree class}
\description{
This S4 class is essentially a wrapper around a \code{\link{CppQuadtree}} C++
object. \code{Quadtree} has one slot, which is named \code{ptr} and contains
a \code{\link{CppQuadtree}} object. Instances of this class can be created
through the \code{\link{quadtree}()} function.

An important note to make is that functions that modify a \code{Quadtree}
modify the existing object. For example, running
\code{\link{transform_values}(qt, function(x) x+1)} modifies \code{qt}. This
differs from the way R objects usually function - most functions that modify
R objects return a modified copy of the object, thus preserving the original
object. Note that the \code{\link{copy}()} function, which makes a deep copy
of a \code{Quadtree}, can be used to preserve a copy of a \code{Quadtree}
before modifying it.

The methods of the C++ object (\code{\link{CppQuadtree}}) stored in the
\code{ptr} slot can be accessed from R, but the typical end-user should have
no need of these methods - they are meant for internal use. That being said,
descriptions of the available methods can be found on the
\code{\link{CppQuadtree}} documentation page.
}
\details{
Functions for creating a \code{Quadtree} object: \itemize{
  \item \code{\link{quadtree}()}
  \item \code{\link{read_quadtree}()}
}
Methods:
\itemize{
  \item \code{\link{as_data_frame}()}
  \item \code{\link{as_raster}()}
  \item \code{\link{as_vector}()}
  \item \code{\link{copy}()}
  \item \code{\link{extent}()}
  \item \code{\link{extract}()}
  \item \code{\link{get_neighbors}()}
  \item \code{\link{lcp_finder}()}
  \item \code{\link{n_cells}()}
  \item \code{\link{projection}()}
  \item \code{\link[=plot.Quadtree]{plot}()}
  \item \code{\link{set_values}()}
  \item \code{\link[=show.Quadtree]{show}()}
  \item \code{\link[=summary.Quadtree]{summary}()}
  \item \code{\link{transform_values}()}
  \item \code{\link{write_quadtree}()}
}
}
\section{Slots}{

\describe{
\item{\code{ptr}}{a C++ object of class \code{CppQuadtree}}
}}

