#'AQS Q-set criteria scores and derived scales
#'
#'A data frame containing the Attachment Q-set (aqs; version
#'3.0). In this dataset, column names ending in "_c"
#'refer to criteria sorts' scores, while column names ending in "_s" refer to
#'scales' scores.
#'
#'@format AQS dataset with 90 rows (items)
#'  and 9 columns.
#'  \describe{
#'    \item{item}{Item number from 1 to 90.}
#'    \item{qset}{aqs. Attachment Q-set (version 3.0) (Waters, 1995).}
#'    \item{sec_c}{Security criterion scores
#'    (retrieved from Waters et al., 1995).}
#'    \item{dep_c}{Dependency criterion scores
#'    (retrieved from Waters et al., 1995).}
#'    \item{pederson_s}{Pederson & Moran's (1995) scales
#'    (retrieved from Waters et al., 1995). comp = compliance; sb = secure base,
#'    fd = fussy/difficult; epc = enjoys physical contact; as = affective sharing.}
#'    \item{pederson_s_inv}{Items to be inverted in Pederson and Moran scales.}
#'    \item{posada_s}{Posada et al.'s (1995) scales (retrieved from Waters et al.,
#'    1995). sim = smooth interactions with mother; pcm = physical contact with
#'    mother; ioa = interactions with other adults; pm = proximity to mother.}
#'    \item{posada_s_inv}{Items to be inverted in Posada et al.'s scales.}
#'    \item{description}{Item description (retrieved from Waters, 1995).}} 
#'
#'@references Posada, G., Waters, E., Crowell, J. A., & Lay, K. (1995). Is it easier to
#'  use a secure mother as a secure base? Attachment Q-Sort correlates of the
#'  adult attachment interview. Monographs of the Society for Research in Child
#'  Development, 60 (2/3), 133-145.
#'
#'  Pederson, D. R., & Moran, G. (1995). A categorical description of
#'  infant-mother relationships in the home and its relation to Q-sort measures
#'  of infant-mother interaction. Monographs of the Society for Research in
#'  Child Development, 60 (2/3), 111-132.
#'
#'  Waters, E. (1995). Appendix A: The attachment Q-set (Version 3. 0).
#'  Monographs of the Society for Research in Child Development, 60 (2/3),
#'  234-246.
#'
#'  Waters, E., Vaughn, B. E., Posada, G., & Kondo-Ikemura, K. (1995). Appendix
#'  D: Scoring key for Q-sort criteria and derived scales in the attachment
#'  Q-set and the attachment Q-set for infant macaques item sets. Monographs of
#'  the Society for Research in Child Development, 60 (2/3), 280-282.
#'
"qset_aqs"