% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/qryflow.R
\name{qryflow_execute}
\alias{qryflow_execute}
\title{Execute a parsed qryflow SQL workflow}
\usage{
qryflow_execute(x, con, ..., source = NULL)
}
\arguments{
\item{x}{A parsed qryflow workflow object, typically created by \code{\link[=qryflow_parse]{qryflow_parse()}}}

\item{con}{A database connection from \code{\link[DBI:dbConnect]{DBI::dbConnect()}}}

\item{...}{Reserved for future use.}

\item{source}{Optional; a character string indicating the source SQL to include in metadata.}
}
\value{
An object of class \code{qryflow_result}, containing executed chunks with results and a \code{meta} field
that includes timing and source information.
}
\description{
\code{qryflow_execute()} takes a parsed workflow object (as returned by \code{\link[=qryflow_parse]{qryflow_parse()}}),
executes each chunk (e.g., \verb{@query}, \verb{@exec}), and collects the results and timing metadata.

This function is used internally by \code{\link[=qryflow_run]{qryflow_run()}}, but can be called directly in concert with \code{\link[=qryflow_parse]{qryflow_parse()}} if you want
to manually control parsing and execution.
}
\examples{
con <- example_db_connect(mtcars)

filepath <- example_sql_path("mtcars.sql")

parsed <- qryflow_parse(filepath)

executed <- qryflow_execute(parsed, con, source = filepath)

DBI::dbDisconnect(con)
}
\seealso{
\code{\link[=qryflow_run]{qryflow_run()}}, \code{\link[=qryflow_parse]{qryflow_parse()}}
}
