% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/multqrsvm.R
\name{multqrsvm}
\alias{multqrsvm}
\title{Fits multiple Quantile Regression SVM}
\usage{
multqrsvm(x, y, kernel = "rbfdot", cost = 1, tau = c(0.05, 0.25, 0.5,
  0.75, 0.95), sigma = 5, degree = 2, scale = 1, offset = 1,
  order = 1, doPar = FALSE, clustnum = 2)
}
\arguments{
\item{x}{An n X m matrix containing the predictors (n= number of observatiosn, m = number of predictors) .}

\item{y}{The Response onto which the qrsvm shall be fitted}

\item{kernel}{a string giving the type of kernels from package kernlab to use f.e. "rbfdot" for Radial Basis Function Kernel. All Kernels except "stringdot" supported.}

\item{cost}{The Cost parameter see f.e. package "e1071" and "kernlab"}

\item{tau}{The Quantile that shall be estimated. A Vector of values (0<=tau<=1)}

\item{sigma}{A possible tuning parameter for specific Kernelfunctions, see package kernlab.}

\item{degree}{A possible tuning parameter for specific Kernelfunctions, see package kernlab.}

\item{scale}{A possible tuning parameter for specific Kernelfunctions, see package kernlab.}

\item{offset}{A possible tuning parameter for specific Kernelfunctions, see package kernlab.}

\item{order}{A possible tuning parameter for specific Kernelfunctions, see package kernlab.}

\item{doPar}{Should a parallel backend be used. Logical.}

\item{clustnum}{The number of parallel tasks to use given doPar==TRUE. Default = 2.}
}
\value{
An object of class "qrsvm"
}
\description{
Fits multiple Quantile Regression SVM
}
\details{
There is no preimplemented scaling of the input variables which should be considered beforehand. Also optimization is based on "quadprog:solve.QP" function which can be considerably slow compared to other SVM implementations.
}
\examples{
n<-200

x<-as.matrix(seq(-2,2,length.out = n))
y<-rnorm(n)*(0.3+abs(sin(x)))

plot(x,y)

models<-list()
quant<-c(0.01,0.25,0.5,0.75,0.99)
models<-multqrsvm(x,y,tau = quant, doPar=FALSE, sigma = 1)
for(i in 1:length(models)){
 lines(x, models[[i]]$fitted, col="red")
}
}
\references{
"Nonparametric Quantile Regression" by I.Takeuchi, Q.V. Le, T. Sears, A.J. Smola (2004)
}
