% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/genomic_matrix.R
\name{adjustB}
\alias{adjustB}
\title{Adjust B-values}
\usage{
adjustB(
  b = NULL,
  LD = NULL,
  msize = NULL,
  overlap = NULL,
  shrink = 0.001,
  threshold = 1e-08
)
}
\arguments{
\item{b}{A numeric vector containing the B-values to be adjusted. If NULL (default), no adjustments are made.}

\item{LD}{A matrix representing the linkage disequilibrium (LD) structure.}

\item{msize}{An integer specifying the size of the subsets.}

\item{overlap}{An integer specifying the overlap size between consecutive subsets.}

\item{shrink}{A numeric value used for shrinkage. Default is 0.001.}

\item{threshold}{A numeric value specifying the threshold. Default is 1e-8.}
}
\value{
A list containing the adjusted B-values.
}
\description{
This function adjusts the B-values based on the LD structure and other parameters.
The adjustment is done in subsets, and a plot of observed vs. predicted values is produced for each subset.
}
\keyword{internal}
