% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/qfa1.2.R
\name{qper2qcoh}
\alias{qper2qcoh}
\title{Quantile Coherence Spectrum (QCOH)}
\usage{
qper2qcoh(qspec, k = 1, kk = 2)
}
\arguments{
\item{qspec}{array of quantile spectrum and cross-spectrum}

\item{k}{index of first series (default = 1)}

\item{kk}{index of second series (default = 2)}
}
\value{
matrix of quantile coherence evaluated at Fourier frequencies in (0,0.5)
}
\description{
This function computes quantile coherence spectrum (QCOH) from quantile spectrum and cross-spectrum.
}
\examples{
y1 <- stats::arima.sim(list(order=c(1,0,0), ar=0.5), n=64)
y2 <- stats::arima.sim(list(order=c(1,0,0), ar=-0.5), n=64)
tau <- seq(0.1,0.9,0.05)
n <- length(y1)
ff <- c(0:(n-1))/n
sel.f <- which(ff > 0 & ff < 0.5)
y.qdft <- qdft(cbind(y1,y2),tau)
qacf <- qdft2qacf(y.qdft)
qper.lw <- qspec.lw(qacf,M=5)$spec
qcoh <- qper2qcoh(qper.lw,k=1,kk=2)
qfa.plot(ff[sel.f],tau,Re(qcoh))
}
