% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/rm_citation.R
\name{rm_citation}
\alias{ex_citation}
\alias{rm_citation}
\title{Remove/Replace/Extract Citations}
\usage{
rm_citation(text.var, trim = !extract, clean = TRUE,
  pattern = "@rm_citation", replacement = "", extract = FALSE,
  dictionary = getOption("regex.library"), ...)

ex_citation(text.var, trim = !extract, clean = TRUE,
  pattern = "@rm_citation", replacement = "", extract = TRUE,
  dictionary = getOption("regex.library"), ...)
}
\arguments{
\item{text.var}{The text variable.}

\item{trim}{logical.  If \code{TRUE} removes leading and trailing white
spaces.}

\item{clean}{trim logical.  If \code{TRUE} extra white spaces and escaped
character will be removed.}

\item{pattern}{A character string containing a regular expression (or
character string for \code{fixed = TRUE}) to be matched in the given
character vector (see \bold{Details} for additional information).  Default,
\code{@rm_citation} uses the \code{rm_citation} regex from the regular
expression dictionary from the \code{dictionary} argument.}

\item{replacement}{Replacement for matched \code{pattern}.}

\item{extract}{logical.  If \code{TRUE} the dates are extracted into a
list of vectors.}

\item{dictionary}{A dictionary of canned regular expressions to search within
if \code{pattern} begins with \code{"@rm_"}.}

\item{\dots}{Ignored.}
}
\value{
Returns a character string with citations removed.
}
\description{
Remove/replace/extract APA6 style citations from a string.
}
\details{
The default regular expression used by \code{rm_citation} finds
in-text and parenthetical citations.  This behavior can be altered by using a
secondary regular expression from the \code{\link[qdapRegex]{regex_usa}}
data (or other dictionary) via (\code{pattern = "@rm_citation2"} or
\code{pattern = "@rm_citation3"}). See \bold{Examples} for example usage.
}
\examples{
## All Citations
x <- c("Hello World (V. Raptor, 1986) bye",
    "Narcissism is not dead (Rinker, 2014)",
    "The R Core Team (2014) has many members.",
    paste("Bunn (2005) said, \\"As for elegance, R is refined, tasteful, and",
        "beautiful. When I grow up, I want to marry R.\\""),
    "It is wrong to blame ANY tool for our own shortcomings (Baer, 2005).",
    "Wickham's (in press) Tidy Data should be out soon.",
    "Rinker's (n.d.) dissertation not so much.",
    "I always consult xkcd comics for guidance (Foo, 2012; Bar, 2014).",
    "Uwe Ligges (2007) says, \\"RAM is cheap and thinking hurts\\""
)

rm_citation(x)
ex_citation(x)
rm_citation(x, replacement="[CITATION HERE]")
\dontrun{
qdapTools::vect2df(sort(table(unlist(rm_citation(x, extract=TRUE)))),
    "citation", "count")
}

## In-Text
ex_citation(x, pattern="@rm_citation2")

## Parenthetical
ex_citation(x, pattern="@rm_citation3")

\dontrun{
## Mining Citation
if (!require("pacman")) install.packages("pacman")
pacman::p_load(qdap, qdapTools, dplyr, ggplot2)

url_dl("http://umlreading.weebly.com/uploads/2/5/2/5/25253346/whole_language_timeline-updated.docx")

parts <- read_docx("whole_language_timeline-updated.docx") \%>\%
    rm_non_ascii() \%>\%
    split_vector(split = "References", include = TRUE, regex=TRUE)

parts[[1]]

parts[[1]] \%>\%
    unbag() \%>\%
    ex_citation() \%>\%
    c()

## By line
ex_citation(parts[[1]])

## Frequency
cites <- parts[[1]] \%>\%
    unbag() \%>\%
    ex_citation() \%>\%
    c() \%>\%
    data_frame(citation=.) \%>\%
    count(citation) \%>\%
    arrange(n) \%>\%
    mutate(citation=factor(citation, levels=citation))

## Distribution of citations (find locations and then plot)
cite_locs <- do.call(rbind, lapply(cites[[1]], function(x){
    m <- gregexpr(x, unbag(parts[[1]]), fixed=TRUE)
    data.frame(
        citation=x,
        start = m[[1]] -5,
        end =  m[[1]] + 5 + attributes(m[[1]])[["match.length"]]
    )
}))

ggplot(cite_locs) +
    geom_segment(aes(x=start, xend=end, y=citation, yend=citation), size=3,
        color="yellow") +
    xlab("Duration") +
    scale_x_continuous(expand = c(0,0),
        limits = c(0, nchar(unbag(parts[[1]])) + 25)) +
    theme_grey() +
    theme(
        panel.grid.major=element_line(color="grey20"),
        panel.grid.minor=element_line(color="grey20"),
        plot.background = element_rect(fill="black"),
        panel.background = element_rect(fill="black"),
        panel.border = element_rect(colour = "grey50", fill=NA, size=1),
        axis.text=element_text(color="grey50"),
        axis.title=element_text(color="grey50")
    )
}
}
\seealso{
\code{\link[base]{gsub}},
\code{\link[stringi]{stri_extract_all_regex}}

Other rm_.functions: \code{\link{as_numeric}},
  \code{\link{as_numeric2}}, \code{\link{ex_number}},
  \code{\link{rm_number}}; \code{\link{as_time}},
  \code{\link{as_time2}}, \code{\link{ex_time}},
  \code{\link{ex_transcript_time}}, \code{\link{rm_time}},
  \code{\link{rm_transcript_time}};
  \code{\link{ex_abbreviation}},
  \code{\link{rm_abbreviation}}; \code{\link{ex_angle}},
  \code{\link{ex_bracket}},
  \code{\link{ex_bracket_multiple}},
  \code{\link{ex_curly}}, \code{\link{ex_round}},
  \code{\link{ex_square}}, \code{\link{rm_angle}},
  \code{\link{rm_bracket}},
  \code{\link{rm_bracket_multiple}},
  \code{\link{rm_curly}}, \code{\link{rm_round}},
  \code{\link{rm_square}}; \code{\link{ex_between}},
  \code{\link{ex_between_multiple}},
  \code{\link{rm_between}},
  \code{\link{rm_between_multiple}};
  \code{\link{ex_caps_phrase}},
  \code{\link{rm_caps_phrase}}; \code{\link{ex_caps}},
  \code{\link{rm_caps}}; \code{\link{ex_citation_tex}},
  \code{\link{rm_citation_tex}};
  \code{\link{ex_city_state_zip}},
  \code{\link{rm_city_state_zip}};
  \code{\link{ex_city_state}}, \code{\link{rm_city_state}};
  \code{\link{ex_date}}, \code{\link{rm_date}};
  \code{\link{ex_default}}, \code{\link{rm_default}};
  \code{\link{ex_dollar}}, \code{\link{rm_dollar}};
  \code{\link{ex_email}}, \code{\link{rm_email}};
  \code{\link{ex_emoticon}}, \code{\link{rm_emoticon}};
  \code{\link{ex_endmark}}, \code{\link{rm_endmark}};
  \code{\link{ex_hash}}, \code{\link{rm_hash}};
  \code{\link{ex_nchar_words}},
  \code{\link{rm_nchar_words}}; \code{\link{ex_non_ascii}},
  \code{\link{rm_non_ascii}}; \code{\link{ex_non_words}},
  \code{\link{rm_non_words}}; \code{\link{ex_percent}},
  \code{\link{rm_percent}}; \code{\link{ex_phone}},
  \code{\link{rm_phone}}; \code{\link{ex_postal_code}},
  \code{\link{rm_postal_code}};
  \code{\link{ex_repeated_characters}},
  \code{\link{rm_repeated_characters}};
  \code{\link{ex_repeated_phrases}},
  \code{\link{rm_repeated_phrases}};
  \code{\link{ex_repeated_words}},
  \code{\link{rm_repeated_words}}; \code{\link{ex_tag}},
  \code{\link{rm_tag}}; \code{\link{ex_title_name}},
  \code{\link{rm_title_name}};
  \code{\link{ex_twitter_url}}, \code{\link{ex_url}},
  \code{\link{rm_twitter_url}}, \code{\link{rm_url}};
  \code{\link{ex_white}}, \code{\link{ex_white_bracket}},
  \code{\link{ex_white_colon}},
  \code{\link{ex_white_comma}},
  \code{\link{ex_white_endmark}},
  \code{\link{ex_white_lead}},
  \code{\link{ex_white_lead_trail}},
  \code{\link{ex_white_multiple}},
  \code{\link{ex_white_punctuation}},
  \code{\link{ex_white_trail}}, \code{\link{rm_white}},
  \code{\link{rm_white_bracket}},
  \code{\link{rm_white_colon}},
  \code{\link{rm_white_comma}},
  \code{\link{rm_white_endmark}},
  \code{\link{rm_white_lead}},
  \code{\link{rm_white_lead_trail}},
  \code{\link{rm_white_multiple}},
  \code{\link{rm_white_punctuation}},
  \code{\link{rm_white_trail}}; \code{\link{ex_zip}},
  \code{\link{rm_zip}}
}
\keyword{citation}

