% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/qb_records.R
\name{query_records}
\alias{query_records}
\title{Query for data}
\usage{
query_records(
  subdomain,
  auth,
  from,
  select = as.numeric(),
  where = NULL,
  group_by = NULL,
  sort_by = NULL,
  agent = NULL,
  skip = 0,
  top = 0,
  local_time = FALSE,
  type_suffix = FALSE
)
}
\arguments{
\item{subdomain}{Character vector with one element. Found at the beginning of
the Quickbase URL. Realm specific.}

\item{auth}{Character vector with one element. The Quickbase authentication
scheme you are using to authenticate the request (e.g., user token).}

\item{from}{Character vector with one element. Table identifier.}

\item{select}{Optional. Numeric vector containing field identifiers for
columns to return. If omitted, the default columns for the table will be
returned.}

\item{where}{Optional. Character vector with one element. Use the Quickbase
query language to set criteria for records to returned.}

\item{group_by}{Optional. Nested named list with 'fieldId' and 'grouping'
pairs for each field to group by.}

\item{sort_by}{Optional. Nested named list with 'fieldId' and sort 'order'
pairs for each field to sort by. See
\href{https://developer.quickbase.com/operation/runQuery}{Quickbase JSON
API documentation} for details on sort order configuration.}

\item{agent}{Optional. Character vector with one element. Describes
user/agent making API call.}

\item{skip}{Optional. Integer. The number of rows to skip from the top of a
record set.}

\item{top}{Optional. Integer. The limit on the number of records to pull
starting at the top of a record set.}

\item{local_time}{Logical. When true, date time fields are returned using
app's local time. When false, date time fields are returned using UTC time.}

\item{type_suffix}{Optional. Logical. Set TRUE to append each field label
with its Quickbase data type.}
}
\value{
A tibble.
}
\description{
Get tabular data from a Quickbase table using a query.
}
\examples{
\dontrun{

   # Get all data matching query specification
   my_tibble <- query_records(subdomain = "abc",
       auth = keyring::key_get("qb_example"),
       from = "bn9d8iesz",
       select = c(3, 6:9),
       where = "{8.EX.'6-month'}")

   # Query data, group, then sort it
   my_tibble <- query_records(subdomain = "bhi",
       auth = keyring::key_get("qb_example"),
       from = "bn9d8iesz",
       select = c(3, 8:12),
       sort_by = list(list(fieldId = 12, order = "ASC"),
                      list(fieldId = 3, order = "DESC")),
       group_by = list(list(fieldId = 4, grouping = "equal-values"),
                       list(fieldId = 9, grouping = "equal-values")))
}
}
