% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/qb_usertoken.R
\name{deactivate_token}
\alias{deactivate_token}
\title{Deactivate a user token}
\usage{
deactivate_token(subdomain, auth, agent = NULL)
}
\arguments{
\item{subdomain}{Character vector with one element. Found at the beginning of
the Quickbase URL. Realm specific.}

\item{auth}{Character vector with one element. The Quickbase authentication
scheme you are using to authenticate the request (e.g., user token).}

\item{agent}{Optional. Character vector with one element. Describes
user/agent making API call.}
}
\value{
A message confirming deactivation was successful.
}
\description{
\code{deactivate_token} makes an active user token inactive.
}
\examples{
\dontrun{
   x <- deactivate_token(subdomain = "abc",
                    auth = keyring::key_get("qb_example"))
}
}
