/*
 * Decompiled with CFR 0.152.
 */
package eu.kliegr.ac1.rule;

public class RuleQuality {
    Integer a;
    Integer b;
    Integer c;
    Integer d;
    Integer n;

    public RuleQuality(float support, float confidence, int totalTransactions) {
        int a = (int)(support * (float)totalTransactions);
        int b = (int)((float)a / confidence) - a;
        this.a = a;
        this.b = b;
        this.n = totalTransactions;
    }

    public RuleQuality(int a, int b, int n) {
        this.a = a;
        this.b = b;
        this.n = n;
    }

    public RuleQuality(int a, int b) {
        this.a = a;
        this.b = b;
    }

    public RuleQuality(int a, int b, int c, int d) {
        this.a = a;
        this.b = b;
        this.c = c;
        this.d = d;
        this.n = a + b + c + d;
    }

    public String toString() {
        return this.toString(false);
    }

    public String toString(boolean verbose) {
        if (verbose) {
            return " supp=" + this.getRelativeSupport() + ",conf=" + this.getConfidence();
        }
        return this.getRelativeSupport() + "," + this.getConfidence();
    }

    public Integer getA() {
        return this.a;
    }

    public Integer getB() {
        return this.b;
    }

    public Integer getC() {
        return this.c;
    }

    public Integer getD() {
        return this.d;
    }

    public float getConfidence() {
        if (this.a + this.b == 0) {
            return 0.0f;
        }
        return (float)this.a.intValue() / (float)(this.a + this.b);
    }

    public int getSupport() {
        return this.a;
    }

    public float getRelativeSupport() {
        if (this.n == null) {
            return -1.0f;
        }
        return (float)this.a.intValue() / (float)this.n.intValue();
    }
}

