% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/pystr_rfind.R
\name{pystr_rfind}
\alias{pystr_rfind}
\title{Find the highest index of a substring.}
\usage{
pystr_rfind(str, sub, start = 1, end = nchar(str))
}
\arguments{
\item{str}{A string.}

\item{sub}{A string.}

\item{start}{An integer.}

\item{end}{An integer.}
}
\value{
An integer. Returns \code{-1} if \code{sub} is not found.
}
\description{
Return the higest index in the string where substring \code{sub} is found,
such that \code{sub} is contained in the slice \code{substr(str, start, end)}.
}
\examples{
pystr_rfind("abcdxyzabc", "abc")
pystr_rfind("abc", "xy")
pystr_rfind("abcxyzabc", "abc", 4)
}
\references{
\url{https://docs.python.org/3/library/stdtypes.html#str.rfind}
}
\seealso{
\code{\link{pystr_find}}
}

