% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/pystr_endswith.R
\name{pystr_endswith}
\alias{pystr_endswith}
\title{Check the suffix of a string.}
\usage{
pystr_endswith(str, suffix, start = 1, end = nchar(str))
}
\arguments{
\item{str}{A string.}

\item{suffix}{A string, character vector, or list of strings.}

\item{start}{An integer.}

\item{end}{An integer.}
}
\value{
\code{TRUE} or \code{FALSE}
}
\description{
Return \code{TRUE} if the string \code{str} ends with the specified
\code{suffix}, otherwise return \code{FALSE}.
}
\details{
\code{suffix} can also be a list of suffixes to look for.
With optional \code{start}, test beginning at that position.
With optional \code{end}, stop comparing at that position.
}
\examples{
pystr_endswith("selfie.jpg", ".jpg")
pystr_endswith("selfie.jpg", ".png")
pystr_endswith("selfie.jpg", c(".jpg", ".png"))
pystr_endswith("selfie.jpg", list(".jpg", ".png"))
pystr_endswith("hello world", "ello", 1, 5)
}
\references{
\url{https://docs.python.org/3/library/stdtypes.html#str.endswith}
}
\seealso{
\code{\link{pystr_startswith}}
}

