% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/modify_variable1.R
\name{px_stub}
\alias{px_stub}
\alias{px_stub.px}
\title{STUB}
\usage{
px_stub(x, value, validate)

\method{px_stub}{px}(x, value, validate = TRUE)
}
\arguments{
\item{x}{A px object}

\item{value}{Optional. A character vector of variable names to change to
STUB. This also changes the STUB order. With names in \code{variables}
becoming 1, 2, ... If missing, the current STUB variables are returned.}

\item{validate}{Optional. If TRUE a number of validation checks are performed on the px object, and an error is thrown if the object is not valid. If FALSE, the checks are skipped, which can be usefull for large px objects where the check can be time consuming. Use \code{\link[=px_validate]{px_validate()}} to manually preform the check.}
}
\value{
A px object or a character vector.
}
\description{
Inspect or change STUB.
}
\examples{
x1 <- px(population_gl)
# Print STUB
px_stub(x1)
# Add 'year' to STUB
x2 <- px_stub(x1, 'year')
px_stub(x2)

# Change order of STUB
x3 <- px_stub(x2, c('age', 'gender'))
px_stub(x3)
}
\seealso{
\href{https://www.scb.se/globalassets/vara-tjanster/px-programmen/px-file_format_specification_2013.pdf#\%5B\%7B\%22num\%22\%3A35\%2C\%22gen\%22\%3A0\%7D\%2C\%7B\%22name\%22\%3A\%22XYZ\%22\%7D\%2C184\%2C329\%2C0\%5D}{Statistics Sweden's documentation}

\code{\link{px_heading}} \code{\link{px_figures}}
}
