% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/p-variation.R
\name{AddPvar}
\alias{AddPvar}
\title{Addition of p-variation}
\usage{
AddPvar(PV1, PV2, AddIfPossible = TRUE)
}
\arguments{
\item{PV1}{an object of the class \code{pvar}.}

\item{PV2}{an object of the class \code{pvar}, which has the same \code{p} value as PV1 object.}

\item{AddIfPossible}{\code{logical}. If TRUE (the default), then is is assumed, that two samples has common point. So,
the end of PV1 and the begging of PV2 will be treated as one point if it has the same value.}
}
\value{
An object of the class \code{pvar}. See \code{\link{pvar}}.
}
\description{
Merges two objects of p-variation and effectively recalculates the p-variation of joined sample.
}
\details{
Note: a short form of \code{AddPvar(PV1, PV2} is \code{PV1 + PV2}.
}
\examples{
### creating two pvar objects:
x = rwiener(1000)
PV1 = pvar(x[1:500], 2)
PV2 = pvar(x[500:1000], 2)

layout(matrix(c(1,3,2,3), 2, 2))
plot(PV1)
plot(PV2)
plot(AddPvar(PV1, PV2))
layout(1)

### AddPvar(PV1, PV2) is eqivavalent to PV1 + PV2
IsEqualPvar(AddPvar(PV1, PV2), PV1 + PV2)
}
