% Generated by roxygen2 (4.0.2): do not edit by hand
\name{PvarBreakTest}
\alias{PvarBreakTest}
\alias{plot.PvarBreakTest}
\alias{summary.PvarBreakTest}
\title{Structural break test}
\usage{
PvarBreakTest(x, TimeLabel = as.vector(time(x)), alpha = 0.05,
  FullInfo = TRUE)

\method{plot}{PvarBreakTest}(x, main1 = "Data",
  main2 = "Bridge transformation", ylab1 = x$dname, ylab2 = "BridgeT("
  \%.\% x$dname \%.\% ")", sub2 = NULL, col.PP = 3, cex.PP = 0.5,
  col.BP = 2, cex.BP = 1, cex.DP = 0.5, ...)

\method{summary}{PvarBreakTest}(object, ...)
}
\arguments{
\item{x}{a numeric vector of data values or an object of class \code{pvar}.}

\item{TimeLabel}{numeric, a time index of \code{x}. Used only for plotting.}

\item{alpha}{a small number greater then 0. It indicates the significant level of the test.}

\item{FullInfo}{\code{logical}. If \code{TRUE} (the default) the function will return an object of the class \code{PvarBreakTest}
that saves all useful information. Otherwise only the statistics will by returned.}

\item{main1}{the \code{main} parameter of the data graph.}

\item{main2}{the \code{main} parameter of the Bridge transformation graph.}

\item{ylab1}{the \code{ylab} parameter of the data graph.}

\item{ylab2}{the \code{ylab} parameter of the Bridge transformation graph.}

\item{sub2}{the \code{sub} parameter of the Bridge transformation graph. By default it reports the number of break points.}

\item{col.PP}{the color of partition points.}

\item{cex.PP}{the cex of partition points.}

\item{col.BP}{the color of break points.}

\item{cex.BP}{the cex of break points.}

\item{cex.DP}{the cex of data points.}

\item{object}{the object of the class \code{PvarBreakTest}.}

\item{\dots}{further arguments, passed to \code{print}.}
}
\value{
If \code{FullInfo=TRUE} then function returns an object of the class \code{PvarBreakTest}.
It is the \code{list} that contains:
\item{Stat}{a value of statistics (p-variation of transformed data).}
\item{CriticalValue}{the critical value of the test according to significant level.}
\item{alpha}{the significant level.}
\item{p.value}{approximate p-value.}
\item{reject}{\code{logical}. If \code{TRUE}, the H0 was rejected.}
\item{dname}{the name of data vector.}
\item{p}{the power in p-variation calculus. The test performs only with the \code{p=4}.}
\item{x}{a vector of original data.}
\item{y}{a vector of transformed data (\code{y=BridgeT(x)}).}
\item{Timelabel}{time label of \code{x}. Used only for ploting.}
\item{BreakPoints}{the indexes of break points suggestion.}
\item{Partition}{a vector of indexes that indicates the partition of \code{y} that achieves the p-variation maximum.}
}
\description{
This function performs structural break test that is based on p-variation.
}
\details{
Lets \code{x} be a data that should be tested of structural breaks.
Then the p-variation of the \code{BridgeT(x)} with \code{p=4} is the test's statistics.

The quantiles of H0 distribution is based on Monte-Carlo simulation of 140 millions iterations.
The test is reliable then \code{length(x)} is between 100 and 10000.
The test might work with other lengths too, but it is not tested well.
The test will not compute then \code{length(x)<20}.
}
\examples{
set.seed(1)
MiuDiff <- 0.3
x <- rnorm(250*4, rep(c(0, MiuDiff, 0, MiuDiff), each=250))

plot(x, pch=19, cex=0.5, main='original data, with several shifts of mean')
k <- 50
moveAvg <- filter(x, rep(1/k, k))
lines(time(x), moveAvg, lwd=2, col=2)
legend('topleft', c('sample', 'moving average (k='\%.\%k\%.\%')'),
       lty=c(NA,1), lwd=c(NA, 2), col=1:2, pch=c(19,NA), pt.cex=c(0.7,1)
       ,inset = .03, bg='antiquewhite1')

xtest <- PvarBreakTest(x)
plot(xtest)
}
\author{
Vygantas Butkus <Vygantas.Butkus@gmail.com>
}
\references{
The test was proposed by A. Rackaskas. The test is based on the results given in the flowing article

[1] R. Norvaisa, A. Rackauskas. Convergence in law of partial sum processes in p-variation norm.
Lth. Math. J., 2008., Vol. 48, No. 2, 212-227.
}
\seealso{
Tests statistics is  \code{\link{pvar}} of the data \code{BridgeT(x)}(see  \code{\link{BridgeT}}) with (p=4).
The critical value and the approximate  p-value of the test might by found by functions
\code{\link{PvarQuantile}} and  \code{\link{PvarPvalue}}.
}

