% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/densities-psnorm.R
\name{psnorm}
\alias{psnorm}
\alias{dpsnorm}
\alias{ppsnorm}
\alias{rpsnorm}
\title{Publication Selection Meta-analysis Model}
\usage{
dpsnorm(x, theta, sigma, alpha = c(0, 0.025, 0.05, 1), eta, log = FALSE)

ppsnorm(
  q,
  theta,
  sigma,
  alpha = c(0, 0.025, 0.05, 1),
  eta,
  lower.tail = TRUE,
  log.p = FALSE
)

rpsnorm(n, theta, sigma, alpha = c(0, 0.025, 0.05, 1), eta)
}
\arguments{
\item{x, q}{vector of quantiles.}

\item{theta}{vector of means.}

\item{sigma}{vector of study standard deviations.}

\item{alpha}{vector of thresholds for publication bias.}

\item{eta}{vector of publication probabilities, normalized to sum to 1.}

\item{log, log.p}{logical; If \code{TRUE}, probabilities are given as
\code{log(p)}.}

\item{lower.tail}{logical; If \code{TRUE} (default), the probabilities are
\eqn{P[X\leq x]} otherwise, \eqn{P[X\geq x]}.}

\item{n}{number of observations. If \code{length(n) > 1}, the length is taken
to be the number required.}
}
\value{
\code{dpsnorm} gives the density, \code{ppsnorm} gives the distribution
function, and \code{rpsnorm} generates random deviates.
}
\description{
Density, distribution, quantile, random variate generation, and expectation
calculation for the distribution for the publication selection
meta-analysis model
}
\details{
The effect size distribution for the publication selection model is not
normal, but has itself been selected for. These functions assume
one-sided selection on the effects. These functions do not assume the
existence of an underlying effect size distribution. For these, see
\code{\link{mpsnorm}}.
}
\examples{
rpsnorm(100, theta = 0, sigma = 0.1, eta = c(1, 0.5, 0.1))
}
\references{
Hedges, Larry V. "Modeling publication selection effects
in meta-analysis." Statistical Science (1992): 246-255.

Moss, Jonas and De Bin, Riccardo. "Modelling publication
bias and p-hacking" Forthcoming (2019)
}
