% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/misc_functions.R
\name{predict_inv}
\alias{predict_inv}
\title{Given y solve for x in a simple linear model.}
\usage{
predict_inv(model, y)
}
\arguments{
\item{model}{A simple linear model object (class lm).}

\item{y}{A numerical scalar, the value of the outcome for which we want to calculate the predictor x.}
}
\value{
The estimated value of the predictor.
}
\description{
\code{predict_inv} Calculates the value the predictor x that generates value y with a simple linear model.
}
\examples{
## Spectrophotometry example. Titration curve for riboflavin (nmol/ml). The sample has an absorbance
## of 1.15. Aim is to estimate the concentration of riboflavin in the sample.

Riboflavin <- seq(0, 80, 10)
OD <- 0.0125 * Riboflavin + rnorm(9, 0.6, 0.03)
titration <- data.frame(Riboflavin, OD)

xyplot(OD ~ Riboflavin, data = titration, pch = 16, col = 1, aspect = 3/4) +
  layer(panel.smoother(lwd = 1.5, col = 2, method = "lm", ...))

## Model with intercept different from zero:
model <- lm(OD ~ Riboflavin, data = titration)
glm_coef(model)
predict_inv(model, 1.15)
}
\author{
Josie Athens, Department of Preventive and Social Medicine, University of Otago, New Zealand.
}
