\name{difsm}
\alias{difsm}
\title{Smoothing with a finite difference penalty}
\description{
  This function smoothes signals with a finite difference penalty of
  order 2.
}
\usage{
difsm(y, lambda)
}
\arguments{
  \item{y}{signal to be smoothed: a vector}
  \item{lambda}{smoothing parameter: larger values lead to smoothing}
}
\value{smoothed signal: a vector}
\references{
  Eilers, P.H.C. Parametric Time Warping. Anal. Chem., 2004, 76, 404 - 411
  
  Eilers, P.H.C. A perfect smoother. Anal. Chem., 2003, 75, 3631 - 3636
}
\author{Paul Eilers, Jan Gerretzen}
\examples{
  data(gaschrom)
  plot(gaschrom[1,], type = "l", ylim = c(0, 100))
  lines(difsm(gaschrom[1,], lambda = 1e5), col = 2)
  lines(difsm(gaschrom[1,], lambda = 1e6), col = 3)
  lines(difsm(gaschrom[1,], lambda = 1e7), col = 4)
  }
\keyword{manip}
