% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/search.R
\name{search_routes}
\alias{search_routes}
\title{Search for routes using text}
\usage{
search_routes(
  search_term,
  latitude = NULL,
  longitude = NULL,
  max_distance = NULL,
  route_types = NULL,
  user_id = determine_user_id(),
  api_key = determine_api_key()
)
}
\arguments{
\item{search_term}{Character. Term used to perform search.}

\item{latitude}{Numeric. Latitude in decimal degrees. For example, Flinders
Street Station is at approximately -37.8183 latitude.}

\item{longitude}{Numeric. Longitude in decimal degrees. For example, Flinders
Street Station is at approximately 144.9671 longitude.}

\item{max_distance}{Integer. Optionally filter by maximum distance from the
given location, in metres.}

\item{route_types}{Integer or character vector. Optionally filter by a vector
of route types. A route type can be provided either as a non-negative
integer code, or as a character: "Tram", "Train", "Bus", "Vline" or "Night
Bus". Character inputs are not case-sensitive. Use the
\code{\link{route_types}} function to extract a vector of all route types.}

\item{user_id}{Integer or character. A user ID or devid provided by Public
Transport Victoria. Refer to \code{?ptvapi} for more details.}

\item{api_key}{Character. An API key, with dashes, provided by Public
Transport Victoria. Refer to \code{?ptvapi} for more details.}
}
\value{
A tibble of routes, with the following columns:
\itemize{
\item \code{route_id}
\item \code{route_gtfs_id}
\item \code{route_name}
\item \code{route_type}
\item \code{route_type_description}
\item \code{route_number}
\item \code{geopath}
\item \code{service_status}
\item \code{service_status_timestamp}
}
}
\description{
This function will search routes in which the search term can be found in
one of many fields, such as \code{route_id}, \code{route_gtfs_id}, or \code{route_name}.
The search is case-insensitive. Unlike \code{\link{search_stops}} and
\code{\link{search_outlets}}, this function supports searching for numerics,
and has no minimum character requirement for \code{search_term}.
}
\examples{
\dontrun{
search_routes("Pakenham")
search_routes("Pakenham", route_types = c("Train", "Tram"))
search_routes("Pakenham", route_types = 1)

search_routes(
  "Pakenham",
  latitude = -38.077877,
  longitude = 145.484751
)
search_routes(
  "Pakenham",
  latitude = -38.077877,
  longitude = 145.484751,
  max_distance = 100
)
}
}
