% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wald-test.R
\name{wald.test}
\alias{wald.test}
\title{Wald test for regression coefficients}
\usage{
wald.test(obj, L, k = NULL)
}
\arguments{
\item{obj}{an object of class \code{ptglmm} (obtained from 
\code{ptmixed} or \code{nbmixed}) or \code{ptglm} (obtained from 
\code{ptglm} or \code{nbglm})}

\item{L}{a matrix used to define the hypothesis to test,
in the form $L b = k$}

\item{k}{a vector used to define the hypothesis to test,
in the form $L b = k$. Default is a null vector ($L b = 0$)}
}
\value{
A data frame with the result of the test
}
\description{
Compute a multivariate Wald test for one of the following
models: Poisson-Tweedie GLMM, negative binomial GLMM, 
Poisson-Tweedie GLM, negative binomial GLM. The null
hypothesis has to be specified in the (matrix) form
$L b = k$, where $b$ is the vector of regression coefficients
and $L$ and $k$ are defined below
}
\examples{
\donttest{
# generate data
data(df1, package = 'ptmixed')

# estimate one of the following models: a Poisson-Tweedie or 
# negative binomial GLMM (using ptmixed() or nbmixed()), or
# a Poisson-Tweedie or negative binomial GLM (using ptglm() 
# or nbgml())
fit1 = nbglm(formula = y ~ group*time, data = df1)

# define L for beta2 = beta4 = 0
L = matrix(0, nrow = 2, ncol = 4)
L[1, 2] = L[2, 4] = 1
              
# compute multivariate Wald test
wald.test(obj = fit1, L = L, k = NULL)
}
}
\author{
Mirko Signorelli
}
