% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getseq.R
\name{get.seq}
\alias{get.seq}
\title{Import a Protein Sequence from a Database}
\usage{
get.seq(id, db = 'uniprot', as.string = TRUE)
}
\arguments{
\item{id}{the identifier of the protein of interest.}

\item{db}{a character string specifying the desired database; it must be one of 'uniprot', 'metosite', 'pdb', 'kegg-aa', 'kegg-nt'.}

\item{as.string}{logical, if TRUE the imported sequence will be returned as a character string.}
}
\value{
Returns a protein (or nucleotide) sequence either as a character vector or a as a character string.
}
\description{
Imports a protein sequence from a selected database.
}
\details{
MetOSite uses the same type of protein ID than UniProt. However, if the chosen database is PDB, the identifier should be the 4-character unique identifier characteristic of PDB, followed by colon and the chain of interest. For instance, '2OCC:B' means we are interested in the sequence of chain B from the structure 2OCC. KEGG used its own IDs (see examples).
}
\examples{
get.seq('P01009')
\dontrun{get.seq("hsa:5265", db = "kegg-aa")}
\dontrun{get.seq("1u8f:P", db = "pdb")}
}
\author{
Juan Carlos Aledo
}
