% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/computept.R
\name{computept}
\alias{computept}
\title{Computes a persistence terrace of point cloud data.}
\usage{
computept(data, sp, fun = kde, lim = NULL, by = NULL,
  maxdimension = max(NCOL(data)), lib = "Dionysus", sublevel = FALSE,
  par = FALSE, ncore = NULL)
}
\arguments{
\item{data}{a matrix of n by d, a point cloud of n points in d dimensions.}

\item{sp}{a vector of smoothing parameter values to be used in the persistence terrace.}

\item{fun}{a smoothing function. The default is the Gaussian kernel density estimator.}

\item{lim}{a 2 by d matrix specifying the range of space to compute. The default value is \code{NULL}.}

\item{by}{a numeric value or vector that specifies the grid. The default value is \code{NULL}.}

\item{maxdimension}{a integer of specifying the maximum dimension of persistence terrace to compute.}

\item{lib}{a library to compute persistent homology. The default is "Dionysus".}

\item{sublevel}{a logical value selecting whether persistent homology is computed to super-level sets (\code{FALSE}) or sub-level sets (\code{TRUE}). The default value is \code{FALSE}.}

\item{par}{if \code{TRUE}, the user can compute the persistence terrace in parallel using multiple cores. The default value is FALSE.}

\item{ncore}{an integer selecting the number of cores to use when parallel computing option is selected. The default value is \code{NULL}.}
}
\value{
The function \code{computept} returns a list of the computed persistence terraces up to given dimension. For each dimension, the computed persistence terrace includes the following components:

\item{x}{The vector of the smoothing parameters used in computation. The x-axis of the persistence terrace.}

\item{y}{The vector of filtration where the Betti number changes. The y-axis of the persistence terrace.}

\item{z}{The matrix of Betti numbers.}
}
\description{
Computes a persistence terrace of point cloud data for given smoothing parameters. For the detailed explanation of the parameters \code{data}, \code{sp}, \code{fun}, \code{lim}, \code{by}, \code{lib}, \code{sublevel}, see the R package \code{TDA}. A parallel option is available to reduce computation time.
}
\examples{
# load three circle data
data(three_circle_dat)

# input variables
Xlim <- c(-4,12)
Ylim <- c(-4,9)
lim <- cbind(Xlim, Ylim)
by <- 0.2
spseq <- seq(0.01,1.5,length.out = 10)

# compute persistence terrace
threecirclept <- computept(three_circle_dat,sp=spseq,lim=lim,by=by)

\dontrun{
# compute persistence terrace with parallel option
spseq <- seq(0.01,1.5,length.out = 30)
threecirclept <- computept(three_circle_dat,sp=spseq,lim=lim,by=by,par=TRUE)
}
}
