% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/control_intercor.R
\name{control_intercor}
\alias{control_intercor}
\title{Control function to curate intercorrelations to be used in automatic compositing routine}
\usage{
control_intercor(rxyi = NULL, n = NULL, sample_id = NULL,
  construct_x = NULL, construct_y = NULL, construct_names = NULL,
  facet_x = NULL, facet_y = NULL, intercor_vec = NULL,
  intercor_scalar = 0.5, dx = NULL, dy = NULL, p = 0.5,
  partial_intercor = FALSE, data = NULL, ...)
}
\arguments{
\item{rxyi}{Vector or column name of observed correlations.}

\item{n}{Vector or column name of sample sizes.}

\item{sample_id}{Vector of identification labels for samples/studies in the meta-analysis.}

\item{construct_x, construct_y}{Vector of construct names for constructs designated as "X" or "Y".}

\item{construct_names}{Vector of all construct names to be included in the meta-analysis.}

\item{facet_x, facet_y}{Vector of facet names for constructs designated as "X" or "Y".}

\item{intercor_vec}{Named vector of pre-specified intercorrelations among measures of constructs in the meta-analysis.}

\item{intercor_scalar}{Generic scalar intercorrelation that can stand in for unobserved or unspecified values.}

\item{dx, dy}{\emph{d} values corresponding to \code{construct_x} and \code{construct_y}. These values only need to be supplied for cases in which \code{rxyi} represents a correlation between two measures of the same construct.}

\item{p}{Scalar or vector containing the proportions of group membership corresponding to the \emph{d} values.}

\item{partial_intercor}{For meta-analyses of \emph{d} values only: Logical scalar, vector, or column corresponding to values in \code{rxyi} that determines whether the correlations are to be treated as within-group correlations (i.e., partial correlation controlling for group membership; \code{TRUE}) or not (\code{FALSE}; default).
Note that this only converts correlation values from the \code{rxyi} argument - any values provided in the \code{intercor_vec} or \code{intercor_scalar} arguments must be total correlations or converted to total correlations using the \code{mix_r_2group()} function prior to running \code{control_intercor}.}

\item{data}{Data frame containing columns whose names may be provided as arguments to vector arguments.}

\item{...}{Further arguments to be passed to functions called within the meta-analysis.}
}
\value{
A vector of intercorrelations
}
\description{
Control function to curate intercorrelations to be used in automatic compositing routine
}
\examples{
## Create a dataset in which constructs correlate with themselves
rxyi <- seq(.1, .5, length.out = 27)
construct_x <- rep(rep(c("X", "Y", "Z"), 3), 3)
construct_y <- c(rep("X", 9), rep("Y", 9), rep("Z", 9))
dat <- data.frame(rxyi = rxyi, 
                  construct_x = construct_x, 
                  construct_y = construct_y, 
                  stringsAsFactors = FALSE)
dat <- rbind(cbind(sample_id = "Sample 1", dat), 
             cbind(sample_id = "Sample 2", dat), 
             cbind(sample_id = "Sample 3", dat))

## Identify some constructs for which intercorrelations are not 
## represented in the data object:
construct_names = c("U", "V", "W")

## Specify some externally determined intercorrelations among measures:
intercor_vec <- c(W = .4, X = .1)

## Specify a generic scalar intercorrelation that can stand in for missing values:
intercor_scalar <- .5

control_intercor(rxyi = rxyi, sample_id = sample_id, 
                 construct_x = construct_x, construct_y = construct_y, 
                 construct_names = construct_names, 
                 intercor_vec = intercor_vec, intercor_scalar = intercor_scalar, data = dat)
}
