% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sensitivity.R, R/sensitivity_bootstrap.R,
%   R/sensitivity_cumulative.R, R/sensitivity_leave1out.R
\name{sensitivity}
\alias{sensitivity}
\alias{sensitivity}
\alias{sensitivity_bootstrap}
\alias{sensitivity}
\alias{sensitivity_cumulative}
\alias{sensitivity}
\alias{sensitivity_leave1out}
\title{Sensitivity analyses for meta-analyses}
\usage{
sensitivity(ma_obj, leave1out = TRUE, bootstrap = TRUE, cumulative = TRUE,
  sort_method = "weight", boot_iter = 1000, boot_conf_level = 0.95,
  boot_ci_type = "bca", ...)

sensitivity_bootstrap(ma_obj, boot_iter = 1000, boot_conf_level = 0.95,
  boot_ci_type = "bca", ...)

sensitivity_cumulative(ma_obj, sort_method = "weight", ...)

sensitivity_leave1out(ma_obj, ...)
}
\arguments{
\item{ma_obj}{Meta-analysis object.}

\item{leave1out}{Logical scalar determining whether to compute leave-one-out analyses (\code{TRUE}) or not (\code{FALSE}).}

\item{bootstrap}{Logical scalar determining whether bootstrapping is to be performed (\code{TRUE}) or not (\code{FALSE}).}

\item{cumulative}{Logical scalar determining whether a cumulative meta-analysis is to be computed (\code{TRUE}) or not (\code{FALSE}).}

\item{sort_method}{Method to sort samples in the cumulative meta-analysis. Options are "weight" to sort by weight (default), "n" to sort by sample size, and "inv_var" to sort by inverse variance.}

\item{boot_iter}{Number of bootstrap iterations to be computed.}

\item{boot_conf_level}{Width of confidence intervals to be constructed for all bootstrapped statistics.}

\item{boot_ci_type}{Type of bootstrapped confidence interval (see "type" options for boot::boot.ci for possible arguments). Default is "bca".}

\item{...}{Additional arguments.}
}
\value{
An updated meta-analysis object with sensitivity analyses added.
\itemize{
\item When bootstrapping is performed, the \code{bootstrap} section of the \code{follow_up_analyses} section of the updated \code{ma_obj} returned by this function will contain both a matrix summarizing the mean, variance, and confidence intervals of the boostrapped samples and a table of meta-analytic results from all bootstrapped samples.
\item When leave-one-out analyses are performed, the \code{ma_obj} will acquire a list of leave-one-out results in its \code{follow_up_analyses} section that contains a table of all leave-one-out meta-analyses along with plots of the mean and residual variance of the effect sizes in the meta-analyses.
\item When cumulative meta-analysis is performed, the \code{ma_obj} will acquire a list of cumulative meta-analysis results in its \code{follow_up_analyses} section that contains a table of all meta-analyses computed along with plots of the mean and residual variance of the effect sizes in the meta-analyses, sorted by the order in which studies were added to the meta-analysis.
}
}
\description{
Wrapper function to compute bootstrap analyses, leave-one-out analyses, and cumulative meta-analyses.
This function helps researchers to examine the stability/fragility of their meta-analytic results with bootstrapping and leave-one-out analyses, as well as detect initial evidence of publication bias with cumulative meta-analyses.
}
\examples{
## Run a meta-analysis using simulated UVIRR data:
ma_obj <- ma_r_ic(rxyi = rxyi, n = n, rxx = rxxi, ryy = ryyi, ux = ux,
correct_rr_y = FALSE, data = data_r_uvirr)
ma_obj <- ma_r_ad(ma_obj, correct_rr_y = FALSE)

## Pass the meta-analysis object to the sensitivity() function:
ma_obj <- sensitivity(ma_obj = ma_obj, boot_iter = 10, cumulative = TRUE,
boot_ci_type = "norm", sort_method = "inv_var")

## Examine the tables and plots produced for the IC meta-analysis:
ma_obj$follow_up_analyses$bootstrap$barebones$`Analysis ID = 1`
ma_obj$follow_up_analyses$bootstrap$individual_correction$true_score$`Analysis ID = 1`
ma_obj$follow_up_analyses$leave1out$individual_correction$true_score$`Analysis ID = 1`
ma_obj$follow_up_analyses$cumulative$individual_correction$true_score$`Analysis ID = 1`

## Examine the tables and plots produced for the AD meta-analysis:
ma_obj$follow_up_analyses$bootstrap$artifact_distribution$true_score$`Analysis ID = 1`
ma_obj$follow_up_analyses$leave1out$artifact_distribution$true_score$`Analysis ID = 1`
ma_obj$follow_up_analyses$cumulative$artifact_distribution$true_score$`Analysis ID = 1`
}
