% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cfa_groupwise.R
\name{cfa_groupwise}
\alias{cfa_groupwise}
\title{Confirmatory Factor Analysis (groupwise)}
\usage{
cfa_groupwise(data, ..., group, model = NULL, ordered = FALSE)
}
\arguments{
\item{data}{data frame}

\item{...}{CFA items. Support \code{dplyr::select()} syntax.}

\item{group}{character. group variable. Support \code{dplyr::select()} syntax.}

\item{model}{explicit \code{lavaan} model. Must be specify with \code{model = lavaan_model_syntax}. \ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}}

\item{ordered}{logical. default is \code{FALSE}. If it is set to \code{TRUE}, lavaan will treat it as a ordinal variable and use \code{DWLS} instead of \code{ML}}
}
\value{
data frame with group-wise CFA result
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#stable}{\figure{lifecycle-stable.svg}{options: alt='[Stable]'}}}{\strong{[Stable]}} \cr
This function will run N number of CFA where N = \code{length(group)}, and report the fit measures of CFA in each group.
The function is intended to help you get a better understanding of which group has abnormal fit indicator
}
\details{
All argument must be explicitly specified. If not, all arguments will be treated as CFA items
}
\examples{
# The example is used as the illustration of the function output only.
# It does not imply the data is appropriate for the analysis.
cfa_groupwise(
  data = lavaan::HolzingerSwineford1939,
  group = "school",
  x1:x3,
  x4:x6,
  x7:x9
)
}
