% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/psid_str.R
\name{psid_str}
\alias{psid_str}
\title{Construct the table of PSID data structure}
\usage{
psid_str(varlist, type = "separated")
}
\arguments{
\item{varlist}{A vector of string values or a single string value, including user's self-defined variable name and the year and variable code from PSID website.}

\item{type}{A string value of either "separated" or "integrated", indicating the type of varlist}
}
\value{
A data frame of the data structure of your PSID dataset, with each row represents the year and each column represents the variable
}
\description{
The \code{psid_str()} function provides a simplified solution to build a table of data structure for your PSID dataset with your customized variable names.
}
\details{
This function is influenced by the methodology implemented in the \code{psidtools} package developed by Professor Ulrich Kohler.
To utilize it, users only need to provide either a string vector (which is recommended) or a single value (if copying and pasting from their .do file).
Minimal additional formatting is needed, and users can easily copy and paste year-variable names directly from the PSID website's codebook.
\itemize{
\item This data frame only contains cross-year variables selected by the user to include in their panel dataset.
Do not specify ALL-YEAR variables here (e.g., individual's sex, individual's birth order).
\item The recommended approach for providing the variable list is to separate them into distinct character values and then wrap them within a vector.
For example: \code{c(" hh_age || [13]ER53017  [17]ER66017", " p_age || [13]ER34204")}
\code{hh_age} and \code{p_age} are self-defined variable name. It is up to you! The final data output will show this variable name instead of the variable code like \code{ER34204}.
The \verb{[YY]VARCODE} sequence can be found from the code book of PSID. You do not need to make any changes on them.
Please ensure proper separation between the user-defined variable name and the \verb{[YY]VARCODE} using "||".
Each variable sequence should be placed in a separate string value.
If this method is used, users should set the \code{type} argument to "separated".
\item This function also offers an option for users who wish to copy and paste their code directly from Stata.
Simply copy and paste your code into a single string value without making any alterations.
For instance: \code{"|| hh_age /// [13]ER53017  [17]ER66017 /// || p_age /// [13]ER34204///"}
Note the different position of "||" between the two input methods.
If you utilize this input method, please specify the \code{type} argument as "integrated."
}

The output of this function will be utilized by \code{psid_read()} for reading the dataset into the environment and by \code{psid_reshape()} for renaming and reshaping the panel dataset.
Therefore, it is recommended to execute this function prior to running other functions within this package.
}
\examples{

# Example 1: Separated string input
psid_varlist = c(" hh_age || [13]ER53017 [17]ER66017",
                 " p_age || [13]ER34204")
psid_str(varlist = psid_varlist, type = "separated")

# Example 2: Integrated string input
psid_varlist <- "|| hh_age ///
                [13]ER53017  [17]ER66017 ///
                || p_age ///
                [13]ER34204///" # DO NOT CHANGE ANYTHING
psid_str(varlist = psid_varlist, type = "integrated")
}
