% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/miperform_lr.R
\name{miperform_lr}
\alias{miperform_lr}
\title{Evaluate performance of logistic regression models over MI datasets}
\usage{
miperform_lr(data, nimp = 5, impvar = NULL, Outcome,
  predictors = NULL, cat.predictors = NULL, int.predictors = NULL,
  cal.plot = FALSE, plot.indiv = FALSE, int.val = FALSE,
  method = "boot", B = 250, bw = FALSE, rule = "p",
  type = "individual", p.val = 0.05, force = NULL)
}
\arguments{
\item{data}{Data frame or data matrix with stacked multiple imputed datasets.
The original dataset that contains missing values must be excluded from the
dataset. The imputed datasets must be distinguished by an imputation variable,
specified under impvar.}

\item{nimp}{A numerical scalar. Number of imputed datasets. Default is 5.}

\item{impvar}{A character vector. Name of the variable that distinguishes the
imputed datasets.}

\item{Outcome}{Character vector containing the name of the outcome variable.}

\item{predictors}{Character vector with the names of the predictor variables.
At least one predictor variable must be defined.}

\item{cat.predictors}{A single string or a vector of strings to define the
categorical variables. Default is NULL categorical predictors.}

\item{int.predictors}{A single string or a vector of strings with the names of
the variables that form an interaction pair, separated by a “:” symbol.}

\item{cal.plot}{If TRUE a calibration plot is generated. Default is FALSE.}

\item{plot.indiv}{If TRUE calibration plots of each imputed dataset are
generated.}

\item{int.val}{If TRUE performance measures are reported as a result
of internal validation in each imputed datasets. This is a wrapper function
of Frank Harrell´s validate function as part of the rms package.}

\item{method}{"boot" is the default setting to generate bootstrap corrected
performance measures.}

\item{B}{The number of bootstrap resamples, default is 250.}

\item{bw}{If TRUE backward selection is applied during bootstrap
internal validation. Default is FALSE. Backward selection is done
using the fastbw function of the rms package.}

\item{rule}{Set at "p" for backward selection using the p-value as
criterium when bw=TRUE.}

\item{type}{Set at "individual" for backward selection of
individual predictors when bw=TRUE.}

\item{p.val}{P-value criterium for backward selection when bw=TRUE.}

\item{force}{A vector of integers to define the variables that are forced
in the model during backward selection. The integer value matches
the order of the variable in the model (starting with the intercept).}
}
\value{
A \code{miperform_lr} object from which the following objects 
 can be extracted: ROC results as \code{ROC}, R squared results as \code{R2}, 
 Hosmer and Lemeshow test as \code{HL_test}, linear predictor pooled as \code{LP_pooled}, 
 performance after internal validation as \code{Int_val_pooled}, 
 and \code{Outcome}, \code{nimp}, \code{impvar}, \code{predictors}, 
 \code{cat.predictors}, \code{int.predictors}, \code{int.val}.
}
\description{
\code{miperform_lr} Evaluate Performance of logistic regression models
}
\examples{
miperform_lr(data=lbpmilr, nimp=5, impvar="Impnr",
Outcome=c("Chronic"), predictors=c("Gender", "Pain",
"Tampascale","Smoking","Function", "Radiation", "Age"),
cat.predictors=c("Carrying", "Satisfaction"),
int.predictors=c("Carrying:Smoking", "Gender:Smoking"),
cal.plot=TRUE, plot.indiv = FALSE)

}
\references{
Marshall A, Altman DG, Holder RL, Royston P. Combining estimates of
 interest in prognostic modelling studies after multiple imputation: current
 practice and guidelines. BMC Med Res Methodol. 2009;9:57.

F. Harrell. Regression Modeling Strategies. With Applications to
 Linear Models, Logistic and Ordinal Regression, and Survival Analysis. Springer,
 New York, NY, 2015.

Van Buuren S. (2018). Flexible Imputation of Missing Data. 2nd Edition. Chapman &
 Hall/CRC Interdisciplinary Statistics. Boca Raton.

Harel, O. (2009). The estimation of R2 and adjusted R2 in
 incomplete data sets using multiple imputation. Journal of Applied Statistics,
 36(10), 1109-1118

http://missingdatasolutions.rbind.io/
}
