% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cluster.R
\name{machinefile}
\alias{machinefile}
\title{Convenience for Clustering}
\usage{
machinefile(name)
}
\arguments{
\item{name}{Filename of the hostfile.}
}
\description{
Provides a convenience interface for using MPD-style hostfiles to generate cluster objetcs.
The hostfile should be written as a text file using the MPD style:
one line for each host, which can be followed by a colon and a number
indicating the number of processes to be started on that host. An example
hostfile for starting three processes on two hosts named avalon and
glastonbury would be:
}
\details{
avalon
glastonbury:2
}
\examples{
\dontrun{
	library(parallel)
	cl = makePSOCKcluster(machinefile("mpd.hosts"))
	stopCluster(cl)
}
}

