% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fitted.plr.R
\name{fitted.plr}
\alias{fitted.plr}
\title{Extract Polygonal Linear Model Fitted Values}
\usage{
\method{fitted}{plr}(object, ..., polygon = FALSE, vertices)
}
\arguments{
\item{object}{an object of the class "\emph{plr}".}

\item{...}{further arguments special methods could require.}

\item{polygon}{logical. If \emph{FALSE} the function returns the center and radius 
predicted for polygon. If \emph{TRUE} the function returns an object of the class
"\emph{Polygonal}" representing the fitted polygons.}

\item{vertices}{If \emph{polygon} is \emph{TRUE} a number of vertices should be defined.
Besides, the number of vertices should be greater than 2 and equal to number of vertices
chosen in symbolic polygonal variables.}
}
\value{
ans the fitted values for polygonal linear regression.
}
\description{
The function is used to calculate the fitted center and radius or fitted polygos
from polygonal linear regression model.
}
\examples{
yp <- psim(10, 10) #simulate 10 polygons of 10 sides
xp1 <- psim(10, 10) #simulate 10 polygons of 10 sides
xp2 <- psim(10, 10) #simulate 10 polygons of 10 sides
e <- new.env()
e$yp <- yp
e$xp1 <- xp1
e$xp2 <- xp2
fit <- plr(yp~xp1+xp2-1, e)
fitted(fit) #shows the center and radius fitted from plr
fitted(fit, polygon = TRUE, vertices = 10) #Shows the polygon fitted from plr 
}
