% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/outcome_surv_weibull_ph.R
\docType{class}
\name{OutcomeSurvWeibullPH-class}
\alias{OutcomeSurvWeibullPH-class}
\alias{.outcome_surv_weibull_ph}
\title{\code{OutcomeSurvWeibullPH} Class}
\description{
A class for defining a time-to-event survival analysis with a
Weibull proportional hazards survival distribution.
Objects of class \code{OutcomeSurvWeibullPH} should not be created directly
but by the constructor \code{\link[=outcome_surv_weibull_ph]{outcome_surv_weibull_ph()}}.
}
\section{Slots}{

\describe{
\item{\code{function_stan_code}}{character. Stan function code block containing text to interpolate into Stan model.}

\item{\code{param_stan_code}}{character. Stan parameter code block containing text to interpolate into Stan model.}

\item{\code{likelihood_stan_code}}{character. Stan model likelihood code block containing text
to interpolate into Stan model.}

\item{\code{n_param}}{integer. Number of ancillary parameters for the model to estimate (1).}

\item{\code{param_priors}}{list. Named list of prior distributions on the ancillary parameters in the model.}

\item{\code{time_var}}{character. Variable used for time in \code{TimeToEvent} objects.}

\item{\code{cens_var}}{character. Variable used for censoring in \code{TimeToEvent} objects.}

\item{\code{baseline_prior}}{\code{Prior}. Object of class \code{Prior}
specifying prior distribution for the baseline outcome.}

\item{\code{name_beta_trt.}}{Named vector for beta_trt.}

\item{\code{name_exp_trt.}}{Named vector for exponentiated beta_trt}

\item{\code{alpha_type.}}{How to interpret alpha.}

\item{\code{name_addnl_params.}}{Named vector for additional parameters.}
}}

\seealso{
Other outcome: 
\code{\link{BinaryOutcome-class}},
\code{\link{ContinuousOutcome-class}},
\code{\link{Outcome-class}},
\code{\link{OutcomeBinaryLogistic-class}},
\code{\link{OutcomeContinuousNormal-class}},
\code{\link{OutcomeSurvExponential-class}},
\code{\link{TimeToEvent-class}}
}
\concept{outcome}
