% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simulate_data_baseline.R
\name{baseline_covariates}
\alias{baseline_covariates}
\title{Specify Correlated Baseline Covariates}
\usage{
baseline_covariates(
  names,
  means_int,
  means_ext = means_int,
  covariance_int,
  covariance_ext = covariance_int
)
}
\arguments{
\item{names}{character vector of variable names.}

\item{means_int}{numeric vector of means for internal patients. Must have same length as \code{names}}

\item{means_ext}{numeric vector of means for external patients. Must have same length as \code{names}}

\item{covariance_int}{variance-covariance matrix for generating multivariate normal for internal patients.
Must be square matrix with same number of rows and \code{length(names)}}

\item{covariance_ext}{variance-covariance matrix for generating multivariate normal data for external patients.
Must be square matrix with same number of rows and \code{length(names)}}
}
\value{
\link[=BaselineObject-class]{BaselineObject} to build simulated dataset
}
\description{
Set parameters to generate correlated multivariate normal data for internal and external patients.
}
\examples{
corr_covs <- baseline_covariates(
  names = c("b1", "b2"),
  means_int = c(5, 25),
  covariance_int = covariance_matrix(diag = c(1, 1), upper_tri = 0.4)
)
}
