% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/reverseSeq.R
\name{reverseSeq}
\alias{reverseSeq}
\title{create rev sequences to fasta list}
\usage{
reverseSeq(fasta, revLab = "REV_")
}
\arguments{
\item{fasta}{- an r list with SeqFastaAA}

\item{revLab}{- how to label reverse sequences, default = REV_}
}
\description{
peptides which do not have protein assignment drop out
}
\examples{
library(seqinr)
library(prozor)

#file = file.path(path.package("prozor"),"extdata/fgcz_contaminants_20150123.fasta.gz")
file = system.file("extdata/fgcz_contaminants_20150123.fasta.gz",package = "prozor")
fasta = readPeptideFasta(file = file)
x <- reverseSeq(fasta)


revseq <- reverseSeq(fasta ,revLab = "REV_")
stopifnot(length(revseq) == length(fasta))
stopifnot(grep("^REV_","REV_zz|ZZ_FGCZCont0000|")==1)

tmp <- list(as.SeqFastaAA(("DYKDDDDK"),name="Flag|FLAG|p2079",Annot=""))

reverseSeq(tmp)

}
