% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/main1.R
\name{proteus}
\alias{proteus}
\title{proteus}
\usage{
proteus(
  data,
  target,
  future,
  past,
  ci = 0.8,
  smoother = FALSE,
  t_embed = 30,
  activ = "linear",
  nodes = 32,
  distr = "normal",
  optim = "adam",
  loss_metric = "crps",
  epochs = 30,
  lr = 0.01,
  patience = 10,
  latent_sample = 100,
  verbose = TRUE,
  stride = 1,
  dates = NULL,
  rolling_blocks = FALSE,
  n_blocks = 4,
  block_minset = 30,
  error_scale = "naive",
  error_benchmark = "naive",
  batch_size = 30,
  omit = FALSE,
  seed = 42
)
}
\arguments{
\item{data}{A data frame with time features on columns and possibly a date column (not mandatory)}

\item{target}{Vector of strings. Names of the time features to be jointly analyzed}

\item{future}{Positive integer. The future dimension with number of time-steps to be predicted}

\item{past}{Positive integer. Length of past sequences}

\item{ci}{Positive numeric. Confidence interval. Default: 0.8}

\item{smoother}{Logical. Perform optimal smoothing using standard loess for each time feature. Default: FALSE}

\item{t_embed}{Positive integer. Number of embedding for the temporal dimension. Minimum value is equal to 2. Default: 30.}

\item{activ}{String. Activation function to be used by the forward network. Implemented functions are: "linear", "mish", "swish", "leaky_relu", "celu", "elu", "gelu", "selu", "bent", "softmax", "softmin", "softsign", "softplus", "sigmoid", "tanh". Default: "linear".}

\item{nodes}{Positive integer. Nodes for the forward neural net. Default: 32.}

\item{distr}{String. Distribution to be used by variational model. Implemented distributions are: "normal", "genbeta", "gev", "gpd", "genray", "cauchy", "exp", "logis", "chisq", "gumbel", "laplace", "lognorm". Default: "normal".}

\item{optim}{String. Optimization method. Implemented methods are: "adadelta", "adagrad", "rmsprop", "rprop", "sgd", "asgd", "adam".}

\item{loss_metric}{String. Loss function for the variational model. Three options: "elbo", "crps", "score". Default: "crps".}

\item{epochs}{Positive integer. Default: 30.}

\item{lr}{Positive numeric. Learning rate. Default: 0.01.}

\item{patience}{Positive integer. Waiting time (in epochs) before evaluating the overfit performance. Default: epochs.}

\item{latent_sample}{Positive integer. Number of samples to draw from the latent variables. Default: 100.}

\item{verbose}{Logical. Default: TRUE}

\item{stride}{Positive integer. Number of shifting positions for sequence generation. Default: 1.}

\item{dates}{String. Label of feature where dates are located. Default: NULL (progressive numbering).}

\item{rolling_blocks}{Logical. Option for incremental or rolling window. Default: FALSE.}

\item{n_blocks}{Positive integer. Number of distinct blocks for back-testing. Default: 4.}

\item{block_minset}{Positive integer. Minimum number of sequence to create a block. Default: 3.}

\item{error_scale}{String. Scale for the scaled error metrics. Two options: "naive" (average of naive one-step absolute error for the historical series) or "deviation" (standard error of the historical series). Default: "naive".}

\item{error_benchmark}{String. Benchmark for the relative error metrics. Two options: "naive" (sequential extension of last value) or "average" (mean value of true sequence). Default: "naive".}

\item{batch_size}{Positive integer. Default: 30.}

\item{omit}{Logical. Flag to TRUE to remove missing values, otherwise all gaps, both in dates and values, will be filled with kalman filter. Default: FALSE.}

\item{seed}{Random seed. Default: 42.}
}
\value{
This function returns a list including:
\itemize{
\item model_descr: brief model description (number of tensors and parameters)
\item prediction: a table with quantile predictions, mean, std, mode, skewness and kurtosis for each time feature (and other metrics, such as iqr_to_range, above_to_below_range, upside_prob, divergence).
\item plot: graph with history and prediction for each time feature
\item feature_errors: train and test error for each time feature (me, mae, mse, rmsse, mpe, mape, rmae, rrmse, rame, mase, smse, sce)
\item history: average cross-validation loss across blocks
\item time_log: computation time.
}
}
\description{
Proteus is a Sequence-to-Sequence Variational Model designed for time-feature analysis, leveraging a wide range of distributions for improved accuracy. Unlike traditional methods that rely solely on the normal distribution, Proteus uses various latent models to better capture and predict complex processes. To achieve this, Proteus employs a neural network architecture that estimates the shape, location, and scale parameters of the chosen distribution. This approach transforms past sequence data into future sequence parameters, improving the model's prediction capabilities. Proteus also assesses the accuracy of its predictions by estimating the error of measurement and calculating the confidence interval. By utilizing a range of distributions and advanced modeling techniques, Proteus provides a more accurate and comprehensive approach to time-feature analysis.
}
\references{
https://rpubs.com/giancarlo_vercellino/proteus
}
\author{
Giancarlo Vercellino \email{giancarlo.vercellino@gmail.com}
}
