% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/perb.R
\name{perb}
\alias{perb}
\title{Calculate proportionality metric rho.}
\usage{
perb(counts, ivar = 0, select)
}
\arguments{
\item{counts}{A data.frame or matrix. A "count matrix" with subjects as rows and features as columns.}

\item{ivar}{A numeric scalar. Specificies a reference feature
for additive log-ratio transformation. Argument will now accept
the feature name instead of index.}

\item{select}{Subsets via \code{object@counts[, select]}.
Optional. Use this argument to subset the proportionality
matrix without impacting the value of \code{rho}.}
}
\value{
Returns a \code{propr} object.
}
\description{
\code{perb} returns a \code{propr} object containing a measure of proportionality.
}
\details{
Let d represent any number of features measured across n biological replicates
	subjected to a binary or continuous event E. For example, E could represent case-control
	status, treatment status, treatment dose, or time. This function converts a
	"count matrix" with n rows and d columns into a proportionality matrix of d rows and d
	columns containing rho measurements for each feature pair. One can think of the resultant
	matrix as equivalent to a correlation matrix.

This function uses a centered log-ratio transformation of the data by default,
 but will use an additive log-ratio transformation of the data if a non-zero
 \code{ivar} is provided. When using an additive log-ratio transformation,
 this function will return \code{rho = 0} for each pair containing the
 reference feature.
}
\examples{
randomNum <- sample(1:1000, size = 25 * 10, replace = TRUE)
counts <- matrix(randomNum, nrow = 25, ncol = 10)
rho <- perb(counts, ivar = 0)
}
\seealso{
\code{\link{propr}}, \code{\link{propr-class}}, \code{\link{phit}}
}

