% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/311.Expec_Leng_ADJ_All.R
\name{lengthAAll}
\alias{lengthAAll}
\title{Expected Length summary calculation using 6 adjusted methods (Wald, Wald-T, Likelihood, Score, Logit-Wald, ArcSine)}
\usage{
lengthAAll(n, alp, h, a, b)
}
\arguments{
\item{n}{- Number of trials}

\item{alp}{- Alpha value (significance level required)}

\item{h}{- Adding factor}

\item{a}{- Beta parameters for hypo "p"}

\item{b}{- Beta parameters for hypo "p"}
}
\value{
A dataframe with
 \item{sumLen}{  The sum of the expected length}
 \item{explMean}{  The mean of the expected length}
 \item{explSD}{  The Standard Deviation of the expected length}
 \item{explMax}{  The max of the expected length}
 \item{explLL}{  The Lower limit of the expected length calculated using mean - SD}
 \item{explUL}{  The Upper limit of the expected length calculated using mean + SD}
 \item{method}{Name of the method}
}
\description{
Expected Length summary calculation using 6 adjusted methods (Wald, Wald-T, Likelihood, Score, Logit-Wald, ArcSine)
}
\details{
The sum of length of 6 adjusted methods (Wald, Wald-T, Likelihood, Score, Logit-Wald, ArcSine)  for \code{n} given \code{alp}, \code{a}, \code{b}
}
\examples{
n= 10; alp=0.05; h=2;a=1;b=1;
lengthAAll(n,alp,h,a,b)
}
\references{
[1] 1998 Agresti A and Coull BA.
Approximate is better than "Exact" for interval estimation of binomial proportions.
The American Statistician: 52; 119 - 126.

[2] 1998 Newcombe RG.
Two-sided confidence intervals for the single proportion: Comparison of seven methods.
Statistics in Medicine: 17; 857 - 872.

[3] 2008 Pires, A.M., Amado, C.
Interval Estimators for a Binomial Proportion: Comparison of Twenty Methods.
REVSTAT - Statistical Journal, 6, 165-197.
}
\seealso{
Other Expected length  of adjusted methods: \code{\link{PlotexplAAS}},
  \code{\link{PlotexplAAll}}, \code{\link{PlotexplALR}},
  \code{\link{PlotexplALT}}, \code{\link{PlotexplASC}},
  \code{\link{PlotexplATW}}, \code{\link{PlotexplAWD}},
  \code{\link{PlotlengthAAS}},
  \code{\link{PlotlengthAAll}},
  \code{\link{PlotlengthALR}}, \code{\link{PlotlengthALT}},
  \code{\link{PlotlengthASC}}, \code{\link{PlotlengthATW}},
  \code{\link{PlotlengthAWD}}, \code{\link{lengthAAS}},
  \code{\link{lengthALR}}, \code{\link{lengthALT}},
  \code{\link{lengthASC}}, \code{\link{lengthATW}},
  \code{\link{lengthAWD}}
}
