% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.R
\name{plot_cross_validation_metric}
\alias{plot_cross_validation_metric}
\title{Plot a performance metric vs. forecast horizon from cross validation.
Cross validation produces a collection of out-of-sample model predictions
that can be compared to actual values, at a range of different horizons
(distance from the cutoff). This computes a specified performance metric
for each prediction, and aggregated over a rolling window with horizon.}
\usage{
plot_cross_validation_metric(df_cv, metric, rolling_window = 0.1)
}
\arguments{
\item{df_cv}{The output from fbprophet.diagnostics.cross_validation.}

\item{metric}{Metric name, one of 'mse', 'rmse', 'mae', 'mape', 'coverage'.}

\item{rolling_window}{Proportion of data to use for rolling average of
metric. In [0, 1]. Defaults to 0.1.}
}
\value{
A ggplot2 plot.
}
\description{
This uses fbprophet.diagnostics.performance_metrics to compute the metrics.
Valid values of metric are 'mse', 'rmse', 'mae', 'mape', and 'coverage'.
}
\details{
rolling_window is the proportion of data included in the rolling window of
aggregation. The default value of 0.1 means 10% of data are included in the
aggregation for computing the metric.

As a concrete example, if metric='mse', then this plot will show the
squared error for each cross validation prediction, along with the MSE
averaged over rolling windows of 10% of the data.
}
