% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lmitt.R
\name{lmitt}
\alias{lmitt}
\alias{lmitt.formula}
\alias{lmitt.lm}
\title{Linear Model for Intention To Treat}
\usage{
lmitt(obj, specification, data, ...)

\method{lmitt}{formula}(
  obj,
  specification,
  data,
  absorb = FALSE,
  offset = NULL,
  weights = NULL,
  ...
)

\method{lmitt}{lm}(obj, specification = NULL, ...)
}
\arguments{
\item{obj}{A \code{formula} or a \code{lm} object. See Details.}

\item{specification}{The \code{StudySpecification} to be used.
Alternatively, a formula creating a specification (of the type of that
would be passed as the first argument to \code{\link[=rd_spec]{rd_spec()}}, \code{\link[=rct_spec]{rct_spec()}}, or
\code{\link[=obs_spec]{obs_spec()}}). If the formula includes a \code{\link[=forcing]{forcing()}} element, an RD
specification is created. Otherwise an observational specification is
created. An RCT specification must be created manually using \code{\link[=rct_spec]{rct_spec()}}.}

\item{data}{A \code{data.frame} such as would be passed into \code{\link[=lm]{lm()}}.}

\item{...}{Additional arguments passed to \code{\link[=lm]{lm()}} and other functions.
An example of the latter is \code{dichotomy=}, a formula passed to
\code{\link[=assigned]{assigned()}} and, as appropriate, \code{\link[=ate]{ate()}}, \code{\link[=att]{att()}}, \code{\link[=atc]{atc()}} or
\code{\link[=ato]{ato()}}. It is used to dichotomize a non-binary treatment
variable in \code{specification}. See the Details section of the
\code{ate()} help page for examples.}

\item{absorb}{If \code{TRUE}, fixed effects are included for blocks
identified in the \code{StudySpecification}. Excluded in \code{FALSE}.
Default is \code{FALSE}. The estimates of these fixed effects are
suppressed from the returned object.}

\item{offset}{Offset of the kind which would be passed into \code{\link[=lm]{lm()}}. Ideally,
this should be the output of \code{\link[=cov_adj]{cov_adj()}}.}

\item{weights}{Which weights should be generated? Options are \code{"ate"}
or \code{"ett"}. Alternatively, the output of a manually run \code{ate()}
or \code{ett()} can be used.}
}
\value{
\code{teeMod} object (see Details)
}
\description{
Generates a linear model object to estimate a treatment effect,
with proper estimation of variances accounting for the study
specification.
}
\details{
The first argument to \code{\link[=lmitt]{lmitt()}} should be a formula specifying the
outcome on the left hand side. The right hand side of the formula can be
any of the following:

\itemize{
\item \code{1}: Estimates a main treatment effect.
\item a subgroup variable: Estimates a treatment effect within each level
of your subgrouping variable.
\item a continuous moderator: Estimates a main treatment effect as well as
a treatment by moderator interaction. The moderator is not
automatically centered.
}

Alternatively, \code{obj} can be a pre-created \code{lm} object. No
modification is made to the formula of the object. See the help for
\code{as.lmitt()} for details of this conversion.

The \code{\link[=lmitt]{lmitt()}} function's \code{subset=} argument governs
the subsetting of \code{data} prior to model fitting, just as with \code{\link[=lm]{lm()}}.
Functions such as \code{\link[=rct_spec]{rct_spec()}} that create \code{StudySpecification}s
also take an optional \code{subset=} argument, but its role differs
from that of the \code{subset=} argument of \code{\link[=lm]{lm()}} or \code{\link[=lmitt]{lmitt()}}. The \code{subset=}
argument when creating a \code{StudySpecification} restricts the data used
to generate the \code{StudySpecification}, but has no direct impact on the
future \code{lm()} or \code{lmitt()} calls using that
\code{StudySpecification}. (It can have an indirect impact by excluding
particular units from receiving a treatment assignment or weight. When
treatment assignments or weights are reconstructed from the \code{StudySpecification},
these units will receive NAs, and will be excluded from the \code{lm()}
or \code{lmitt()} fit under typical \code{na.action} settings.)

To avoid variable name collision, the treatment variable defined in the
\code{specification} will have a "\code{.}" appended to it. For example, if
you request a main treatment effect (with a formula of \code{~ 1}) with a
treatment variable named "txt", you can obtain its estimate from the
returned \code{teeMod} object via \code{$coefficients["txt."]}.

\code{\link[=lmitt]{lmitt()}} will produce a message if the \code{StudySpecification}
designates treatment assignment by block but the blocking
structure appears not to be reflected in the \code{weights}, nor
in a block fixed effect adjustment (via \code{absorb=TRUE}). While
not an error, this is at odds with intended uses of
\code{propertee}, so \code{lmitt()} flags it as a potential
oversight on the part of the analyst. To disable this message, run
\code{options("propertee_message_on_unused_blocks" = FALSE)}.

\code{\link[=lmitt]{lmitt()}} returns objects of class \sQuote{\code{teeMod}}, for
Treatment Effect Estimate Model, extending the lm class to add a
summary of the response distribution under control (the
coefficients of a controls-only regression of the response on an
intercept and any moderator variable).  \code{teeMod} objects also
record the underlying \code{StudySpecification} and information
about any externally fitted models \code{mod} that may have been
used for covariance adjustment by passing
\code{offset=cov_adj(mod)}. In the latter case, responses are
offsetted by predictions from \code{mod} prior to treatment effect
estimation, but estimates of the response variable distribution
under control are calculated without reference to \code{mod}.

The response distribution under control is also characterized when
treatment effects are estimated with block fixed effects, i.e. for
\code{\link[=lmitt]{lmitt()}} with a \code{formula} first argument with option
\code{absorb=TRUE}.  Here as otherwise, the supplementary
coefficients describe a regression of the response on an intercept
and moderator variables, to which only control observations
contribute; but in this case the weights are modified for this
supplementary regression. The treatment effect estimates adjusted
for block fixed effects can be seen to coincide with estimates
calculated without block effect but with weights multiplied by an
additional factor specific to the combination of block and
treatment condition. For block \eqn{s} containing units with weights
\eqn{w_i} and binary treatment assignments \eqn{z_i}, define
\eqn{\hat{\pi}_s} by \eqn{\hat{\pi}_s\sum_sw_i=\sum_sz_iw_i}. If
\eqn{\hat{\pi}_s} is 0 or 1, the block doesn't contribute to
effect estimation and the additional weighting factor is 0; if
\eqn{0 < \hat{\pi}_s < 1}, the additional weighting factor is
\eqn{1 - \hat{\pi}_s} for treatment group members and
\eqn{\hat{\pi}_s} for controls. When estimating a main effect only
or a main effect with continuous moderator, supplementary
coefficients under option \code{absorb=TRUE} reflect regressions
with additional weighting factor equal to 0 or \eqn{\hat{\pi}_s},
respectively, for treatment or control group members of block
\eqn{s}. With a categorical moderator and \code{absorb=TRUE},
this additional weighting factor determining supplementary coefficients
is calculated separately for each level \eqn{\ell} of the moderator
variable, with the sums defining \eqn{\hat{\pi}_{s\ell}} restricted
not only to block \eqn{s} but also to observations with moderator
equal to \eqn{\ell}.
}
\examples{
data(simdata)
spec <- rct_spec(z ~ unit_of_assignment(uoa1, uoa2), data = simdata)
mod1 <- lmitt(y ~ 1, data = simdata, specification = spec, weights = "ate")
mod2 <- lmitt(y ~ as.factor(o), data = simdata, specification = spec, weights = "ate")
mod3 <- lmitt(y ~ 1, data = simdata,
              specification = z ~ uoa(uoa1, uoa2) + forcing(force))
}
