% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods.R
\name{pred-projection}
\alias{pred-projection}
\alias{proj_linpred}
\alias{proj_predict}
\title{Predictions from a submodel (after projection)}
\usage{
proj_linpred(
  object,
  newdata = NULL,
  offsetnew = NULL,
  weightsnew = NULL,
  filter_nterms = NULL,
  transform = FALSE,
  integrated = FALSE,
  .seed = sample.int(.Machine$integer.max, 1),
  ...
)

proj_predict(
  object,
  newdata = NULL,
  offsetnew = NULL,
  weightsnew = NULL,
  filter_nterms = NULL,
  nresample_clusters = 1000,
  .seed = sample.int(.Machine$integer.max, 1),
  ...
)
}
\arguments{
\item{object}{An object returned by \code{\link[=project]{project()}} or an object that can be
passed to argument \code{object} of \code{\link[=project]{project()}}.}

\item{newdata}{Passed to argument \code{newdata} of the reference model's
\code{extract_model_data} function (see \code{\link[=init_refmodel]{init_refmodel()}}). Provides the
predictor (and possibly also the response) data for the new (or old)
observations. May also be \code{NULL} (see argument \code{extract_model_data} of
\code{\link[=init_refmodel]{init_refmodel()}}). If not \code{NULL}, any \code{NA}s will trigger an error.}

\item{offsetnew}{Passed to argument \code{orhs} of the reference model's
\code{extract_model_data} function (see \code{\link[=init_refmodel]{init_refmodel()}}). Used to get the
offsets for the new (or old) observations.}

\item{weightsnew}{Passed to argument \code{wrhs} of the reference model's
\code{extract_model_data} function (see \code{\link[=init_refmodel]{init_refmodel()}}). Used to get the
weights for the new (or old) observations.}

\item{filter_nterms}{Only applies if \code{object} is an object returned by
\code{\link[=project]{project()}}. In that case, \code{filter_nterms} can be used to filter \code{object}
for only those elements (submodels) with a number of solution terms in
\code{filter_nterms}. Therefore, needs to be a numeric vector or \code{NULL}. If
\code{NULL}, use all submodels.}

\item{transform}{For \code{\link[=proj_linpred]{proj_linpred()}} only. A single logical value indicating
whether the linear predictor should be transformed to response scale using
the inverse-link function (\code{TRUE}) or not (\code{FALSE}).}

\item{integrated}{For \code{\link[=proj_linpred]{proj_linpred()}} only. A single logical value
indicating whether the output should be averaged across the projected
posterior draws (\code{TRUE}) or not (\code{FALSE}).}

\item{.seed}{Pseudorandom number generation (PRNG) seed by which the same
results can be obtained again if needed. Passed to argument \code{seed} of
\code{\link[=set.seed]{set.seed()}}, but can also be \code{NA} to not call \code{\link[=set.seed]{set.seed()}} at all. Here,
this seed is used for drawing new group-level effects in case of a
multilevel submodel (however, not yet in case of a GAMM) and for drawing
from the predictive distribution of the submodel(s) in case of
\code{\link[=proj_predict]{proj_predict()}}. If a clustered projection was performed, then in
\code{\link[=proj_predict]{proj_predict()}}, \code{.seed} is also used for drawing from the set of the
projected clusters of posterior draws (see argument \code{nresample_clusters}).}

\item{...}{Arguments passed to \code{\link[=project]{project()}} if \code{object} is not already an
object returned by \code{\link[=project]{project()}}.}

\item{nresample_clusters}{For \code{\link[=proj_predict]{proj_predict()}} with clustered projection
only. Number of draws to return from the predictive distribution of the
submodel. Not to be confused with argument \code{nclusters} of \code{\link[=project]{project()}}:
\code{nresample_clusters} gives the number of draws (\emph{with} replacement) from
the set of clustered posterior draws after projection (with this set being
determined by argument \code{nclusters} of \code{\link[=project]{project()}}).}
}
\value{
Let \eqn{S_{\mathrm{prj}}}{S_prj} denote the number of (possibly
clustered) projected posterior draws (short: the number of projected draws)
and \eqn{N} the number of observations. Then, if the prediction is done for
one submodel only (i.e., \code{length(nterms) == 1 || !is.null(solution_terms)}
in the call to \code{\link[=project]{project()}}):
\itemize{
\item \code{\link[=proj_linpred]{proj_linpred()}} returns a \code{list} with elements \code{pred} (predictions,
i.e., the linear predictors, possibly transformed to response scale) and
\code{lpd} (log predictive densities; only calculated if \code{newdata} contains
response values). Both elements are \eqn{S_{\mathrm{prj}} \times N}{S_prj x
  N} matrices.
\item \code{\link[=proj_predict]{proj_predict()}} returns an \eqn{S_{\mathrm{prj}} \times N}{S_prj x N}
matrix of predictions where \eqn{S_{\mathrm{prj}}}{S_prj} denotes
\code{nresample_clusters} in case of clustered projection.
}

If the prediction is done for more than one submodel, the output from above
is returned for each submodel, giving a named \code{list} with one element for
each submodel (the names of this \code{list} being the numbers of solutions
terms of the submodels when counting the intercept, too).
}
\description{
After the projection of the reference model onto a submodel, the linear
predictors (for the original dataset or new data) based on that submodel can
be calculated by \code{\link[=proj_linpred]{proj_linpred()}}. The linear predictors can also be
transformed to response scale. Furthermore, \code{\link[=proj_linpred]{proj_linpred()}} returns the
corresponding log predictive density values if the new dataset contains
response values. The \code{\link[=proj_predict]{proj_predict()}} function draws from the predictive
distribution of the submodel that the reference model has been projected
onto. If the projection has not been performed yet, both functions call
\code{\link[=project]{project()}} internally to perform the projection. Both functions can also
handle multiple submodels at once (for \code{object}s of class \code{vsel} or \code{object}s
returned by a \code{\link[=project]{project()}} call to an object of class \code{vsel}; see
\code{\link[=project]{project()}}).
}
\examples{
if (requireNamespace("rstanarm", quietly = TRUE)) {
  # Data:
  dat_gauss <- data.frame(y = df_gaussian$y, df_gaussian$x)

  # The "stanreg" fit which will be used as the reference model (with small
  # values for `chains` and `iter`, but only for technical reasons in this
  # example; this is not recommended in general):
  fit <- rstanarm::stan_glm(
    y ~ X1 + X2 + X3 + X4 + X5, family = gaussian(), data = dat_gauss,
    QR = TRUE, chains = 2, iter = 500, refresh = 0, seed = 9876
  )

  # Projection onto an arbitrary combination of predictor terms (with a small
  # value for `nclusters`, but only for the sake of speed in this example;
  # this is not recommended in general):
  prj <- project(fit, solution_terms = c("X1", "X3", "X5"), nclusters = 10,
                 seed = 9182)

  # Predictions (at the training points) from the submodel onto which the
  # reference model was projected:
  prjl <- proj_linpred(prj)
  prjp <- proj_predict(prj, .seed = 7364)
}

}
