% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cv_varsel.R
\name{cv_varsel}
\alias{cv_varsel}
\title{Cross-validate the variable selection (varsel)}
\usage{
cv_varsel(fit, method = NULL, cv_method = NULL, ns = NULL, nc = NULL,
  nspred = NULL, ncpred = NULL, nv_max = NULL, intercept = NULL,
  penalty = NULL, verbose = T, nloo = 100, K = NULL, k_fold = NULL,
  lambda_min_ratio = 1e-05, nlambda = 500, regul = 1e-06,
  validate_search = T, ...)
}
\arguments{
\item{fit}{Same as in \link[=varsel]{varsel}.}

\item{method}{Same as in \link[=varsel]{varsel}.}

\item{cv_method}{The cross-validation method, either 'LOO' or 'kfold'. Default is 'LOO'.}

\item{ns}{Number of samples used for selection. Ignored if nc is provided or if method='L1'.}

\item{nc}{Number of clusters used for selection. Default is 1 and ignored if method='L1' 
(L1-search uses always one cluster).}

\item{nspred}{Number of samples used for prediction (after selection). Ignored if ncpred is given.}

\item{ncpred}{Number of clusters used for prediction (after selection). Default is 5.}

\item{nv_max}{Same as in \link[=varsel]{varsel}.}

\item{intercept}{Same as in \link[=varsel]{varsel}.}

\item{penalty}{Same as in \link[=varsel]{varsel}.}

\item{verbose}{Whether to print out some information during the validation, Default is TRUE.}

\item{nloo}{Number of observations used to compute the LOO validation (anything between 1 and the 
total number of observations). Smaller values lead to
faster computation but higher uncertainty (larger errorbars) in the accuracy estimation.
Default value is 100. Only applicable if \code{cv_method = LOO}.}

\item{K}{Number of folds in the k-fold cross validation. Only applicable
if \code{cv_method = TRUE} and \code{k_fold = NULL}.}

\item{k_fold}{An array with cross-validated stanfits and the respective
test datasets returned by \link[=kfold]{kfold} with \code{save_fits=TRUE}.
If not provided, \link[=kfold]{kfold} is called inside the function.}

\item{lambda_min_ratio}{Same as in \link[=varsel]{varsel}.}

\item{nlambda}{Same as in \link[=varsel]{varsel}.}

\item{regul}{Amount of regularization in the projection. Usually there is no need for 
regularization, but sometimes for some models the projection can be ill-behaved and we
need to add some regularization to avoid numerical problems. Default is 1e-9.}

\item{validate_search}{Whether to cross-validate also the selection process, that is, whether to perform
selection separately for each fold. Default is TRUE and we strongly recommend not setting this
to FALSE, because this is known to bias the accuracy estimates for the selected submodels.
However, setting this to FALSE can sometimes be useful because comparing the results to the case
where this parameter is TRUE gives idea how strongly the feature selection is (over)fitted to the
data (the difference corresponds to the search degrees of freedom or the effective number 
of parameters introduced by the selectin process).}

\item{...}{Currently ignored.}
}
\value{
The original \link[=stanreg-objects]{stanreg} object augmented with an element 'varsel',
which is a list containing the following elements:
\describe{
 \item{\code{vind}}{The order in which the variables were added to the submodel.}
 \item{\code{pctch}}{Percentage of cross-validation runs that included the given
   variable to a model of given size.}
 \item{\code{kl}}{KL-divergence for each submodel size.}
 \item{\code{summaries}}{CV-summary statistics computed during the selection.}
 \item{\code{d_test}}{The data used to evaluate the summaries.}
 \item{\code{family_kl}}{A modified \code{\link{family}}-object.}
}
}
\description{
Perform cross-validation for the projective variable selection for a generalized
linear model.
}
\examples{
\donttest{
### Usage with stanreg objects
fit <- stan_glm(y~x, binomial())
fit_cv <- cv_varsel(fit)
}

}
