% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/progressr-package.R
\docType{package}
\name{progressr}
\alias{progressr}
\alias{progressr-package}
\title{progressr: A Unifying API for Progress Updates}
\description{
The \pkg{progressr} package provides a minimal, unifying API for scripts
and packages to report progress updates from anywhere including when
using parallel processing.
}
\details{
The package is designed such that \emph{the developer} can to focus on \emph{what}
progress should be reported on without having to worry about \emph{how} to
present it.

The \emph{end user} has full control of \emph{how}, \emph{where}, and \emph{when} to render
these progress updates.  For instance, they can chose to report progress
in the terminal using \code{\link[utils:txtProgressBar]{utils::txtProgressBar()}} or
\code{\link[progress:progress_bar]{progress::progress_bar()}} or via the graphical user interface (GUI)
using \code{utils::winProgressBar()} or \code{\link[tcltk:tkProgressBar]{tcltk::tkProgressBar()}}.
An alternative to above visual rendering of progress, is to report it
using \code{\link[beepr:beep]{beepr::beep()}} sounds.
It is possible to use a combination of above progression handlers, e.g.
a progress bar in the terminal together with audio updates.
Besides the existing handlers, it is possible to develop custom
progression handlers.

The \pkg{progressr} package uses R's condition framework for signaling
progress updated. Because of this, progress can be reported from almost
anywhere in R, e.g. from classical for and while loops, from map-reduce
APIs like the \code{\link[=lapply]{lapply()}} family of functions, \pkg{purrr}, \pkg{plyr}, and
\pkg{foreach}.
The \pkg{progressr} package will also work with parallel processing via
the \pkg{future} framework, e.g. \code{\link[future.apply:future_lapply]{future.apply::future_lapply()}},
\code{\link[furrr:future_map]{furrr::future_map()}}, and \code{\link[foreach:foreach]{foreach::foreach()}} with \pkg{doFuture}.

The \pkg{progressr} package is compatible with Shiny applications.
}
\section{Progression Handlers}{


In the terminal:
\itemize{
\item \link{handler_txtprogressbar} (default)
\item \link{handler_pbcol}
\item \link{handler_pbmcapply}
\item \link{handler_progress}
\item \link{handler_ascii_alert}
\item \link{handler_debug}
}

In the graphical user interface (GUI):
\itemize{
\item \link{handler_tkprogressbar}
\item \link{handler_winprogressbar}
}

As sound:
\itemize{
\item \link{handler_beepr}
\item \link{handler_ascii_alert}
}

Via the file system:
\itemize{
\item \link{handler_filesize}
}

In Shiny:
\itemize{
\item \link{withProgressShiny}
}
}

\examples{
library(progressr)

xs <- 1:5

with_progress({
  p <- progressor(along = xs)
  y <- lapply(xs, function(x) {
    Sys.sleep(0.1)
    p(sprintf("x=\%g", x))
    sqrt(x)
  })
})
}
\keyword{iteration}
\keyword{programming}
